<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

///////////////////////////////////////////////////////////////////////////////////////////
//  Purpose of file: Item Error Row
///////////////////////////////////////////////////////////////////////////////////////////


$html = "<tr>\n";
// determine if the row id is present
if ($row_item['id']) {
	// item id
	$html.= "<td class=\"h2b t2\" id=\"<!--item-->".$row_item['id']."<!--/item--><!--classification-->".$row_item['classification']."<!--/classification-->\">";
	$html.= $row_item['id'];
	$html.= "</td>\n";
	// Error
	$html.= "<td class=\"h2c e\">";
	foreach ($row_item['error'] as $value) {
		$html.= $value." ";
	}
	$html.= "</td>\n";
	// Brand
	$html.= "<td class=\"h2c t2\" id=\"<!--brand-->\">";
	$html.= $row_item['brand'];
	$html.= "</td>\n";
	// Model
	$html.= "<td class=\"h2c t2\" id=\"<!--/brand--><!--model-->\">";
	$html.= $row_item['model'];
	$html.= "</td>\n";
	// description
	$html.= "<td class=\"h2c t2\" id=\"<!--/model--><!--description-->\">";
	$html.= "<pre class=\"t2\">".wordwrap($row_item['description'],25)."</pre>";
	$html.= "</td>\n";
	// Validity period
	$html.= "<td class=\"h2c t2\" id=\"<!--/description--><!--valid-->\">";
	$html.= $cfg['tender']['validity']['default']." ".$this->lang['days'];
	$html.= "</td>\n";
	// stock
	$html.= "<td class=\"h2c t2\" id=\"<!--/valid--><!--stock-->\">";
	$html.= "1 ".$this->lang['day'];
	$html.= "</td>\n";
	// item price
	$html.= "<td class=\"h2c t2\" id=\"<!--/stock--><!--price-->\">";
	$html.= $cfg['local']['precurrency']."0.00".$cfg['local']['postcurrency'];
	$html.= "</td>\n";
	// closing column - must be present as outlook removes last tag in certain circumstances
	$html.= "<td id=\"<!--/price-->\">";
	$html.= "</td>\n";
	
} else {
	$html.= "<td class=\"h2b t1\" colspan=\"9\">";
	$html.= $this->lang['noitem']." ".$this->lang['resubmit'];
	$html.= "</td>\n";
}
$html.= "</tr>\n";
?>
