<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

///////////////////////////////////////////////////////////////////////////////////////////
// Purpose of file: Email Template
///////////////////////////////////////////////////////////////////////////////////////////

$html = "<tr>\n";
// item id
$html.= "<td class=\"h2b t2\">";
$html.= $row_item['id'];
$html.= "</td>\n";
// brand
$html.= "<td class=\"h2c t2\">";
$html.= $row_item['brand'];
$html.= "</td>\n";
// model
$html.= "<td class=\"h2c t2\">";
$html.= $row_item['model'];
$html.= "</td>\n";
// description
$html.= "<td class=\"h2c t2\">";
$html.= "<pre class=\"t2\">".wordwrap($row_item['description'],25)."</pre>";
$html.= "</td>\n";
// valid
$html.= "<td class=\"h2c t2\">";
$html.= $row_item['valid']." ".$this->lang['days'];
$html.= "</td>\n";
// stock
$html.= "<td class=\"h2c t2\">";
if ($row_item['stock'] == "0") {
	$html.= $this->lang['available'];
} elseif ($row_item['stock'] == "1") {
	$html.= $row_item['stock']." ";
	$html.= $this->lang['day'];
} else {
	$html.= $row_item['stock']." ";
	$html.= $this->lang['days'];
}
$html.= "</td>\n";
// position
$html.= "<td class=\"h2c t2\">";
if($row_item['position']) {
	$html.= '<img border="0" align="top" alt="'.$this->lang['altposition'][$row_item['position']].'" src="'.$cfg['url'].'theme/blue/icon/position/'.$row_item['position'].'.gif"/>';
} else {
	$html.= $this->lang['noposition'];
}
$html.= "</td>\n";
// price
$html.= "<td class=\"h2c t2\">";
if($row_item['classification'] == "1") {
	$html.= $cfg['local']['precurrency'].$row_item['price'].$cfg['local']['postcurrency'];
} else {
	$html.= $this->lang['noquote'];
}
$html.= "</td>\n";

// attachment
if ($row_item['attachment']) {
	$html.= "<td class=\"h2c t2\">";
	$html.= $this->lang['attachment']." : <a href=\"".$cfg['url'].
			"main.php?module=generic&function=attachment&user_id=".$key.
			"&language=".$this->user['language'].
			"&id=".$row_item['attachment'].
			"&authentication=".$row_item['authentication'].
			"\" class=\"error\">".$row_item['name'].
			"</a>";
	$html.= "</td>\n";
} else {
	$html.= "<td>";
	$html.= "</td>\n";
}
// close
$html.= "</tr>\n";
?>