<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

///////////////////////////////////////////////////////////////////////////////////////////
// Purpose of file: Email Template
///////////////////////////////////////////////////////////////////////////////////////////
// set the subject link
$subject = $this->lang['invitesubject']." ".$this->tender['rfq_number']." (".$this->tender['rfq_reference'].")";

// set the body
$html = "<tr>";
$html.= "<td id=\"<!--emailtype-->tender<!--/emailtype-->\">";
$html.= $this->lang['dear']." ".$agent['name'].",";
$html.= "<br/><br/>";
$html.= $this->lang['requiremore']." ".$this->subscriber['name']." ".$this->subscriber['surname'];
$html.= " <a href=\"mailto:".$this->subscriber['email']."?subject=".$subject."\">".$this->lang['email']."</a> ";
$html.= $this->lang['orphone']." (".$this->subscriber['phone_work'].").";
$html.= "<br/><br/>";
$redirect = "quote&tenderid=".$this->tender['id'];
$link = $cfg['url']."index.php?next_module=assessment&next_function=".rawurlencode($redirect)."&next_call_id=".time();
$html.= "<a href=\"".$link."\">".$this->lang['clicktoquote'].".";
$html.= "</a><br/><br/>";
// Information Table
$html.= "<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
$html.= "<tr>";
$html.= "<td class=\"t1\" id=\"<!--id-->".$this->tender['id']."<!--/id-->\">";
$html.= $this->lang['rfq'];
$html.= "</td>";
$html.= "<td class=\"t2\" id=\"<!--user-->".$agent['id']."<!--/user-->\">";
$html.= $this->tender['rfq_number']." (".$this->tender['rfq_reference'].")";
$html.= "</td>";
$html.= "<td class=\"t1\" id=\"<!--requester-->".$this->subscriber['id']."<!--/requester-->\">";
$html.= $this->lang['subscriber'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= "<a href=\"mailto:".$this->subscriber['email']."?subject=".$subject."\">";
$html.= $this->subscriber['name']." ".$this->subscriber['surname'];
$html.= "</a>";
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['contact'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->subscriber['phone_work'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['company'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->subscriber['organisationname']." (".$this->subscriber['branchname'].")";
$html.= "</td>";
$html.= "</tr>";
$html.= "<tr>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['location'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->tender['statename']." : ".$this->tender['areaname'];
$html.= "</td>";
$html.= "<td class=\"t1\">";
$html.= $this->lang['closing'];
$html.= "</td>";
$html.= "<td class=\"t2\">";
$html.= $this->response['closing']." ".$cfg['local']['display'];
$html.= "</td>";
$html.= "</tr>";
$html.= "</table>";
$html.= "<br/>";
// model update message
$html.= $this->lang['pleasenote'];
$html.= " <a href=\"".$cfg['url']."manuals/".$this->subscriber['language']."/demo_message.html\">".$this->lang['clicktoview']."</a>";
// attachment
$attachment = $this->get_attachment_info($this->tender['id'],$cfg,$conn); 
if ($attachment) {
	$html.= "<br/><br/>";
	$html.= "<a href=\"".$cfg['url']."main.php?module=generic&function=attachment&user_id=".$this->subscriber['id']."&language=".$this->subscriber['language']."&id=".$attachment['id']."&authentication=".$attachment['authentication']."\" class=\"error\">".$this->lang['clicktodownload']." <b>".$attachment['name']."</b>".$this->lang['additionalinfo'].".</a>";
}
$html.= "<br/><br/>";
// Tender tables
$html.= "<table width=\"100%\"  border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
$html.= "<tr>";
$html.= "<td class=\"h1 t1\">";
$html.= $this->lang['item'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['category'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['brand'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['model'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['description'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['validity'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['stock'];
$html.= "</td>";
$html.= "<td class=\"h1a t1\">";
$html.= $this->lang['quote'];
$html.= "</td>";
$html.= "<td>";
$html.= "</td>";
$html.= "</tr>";
// Populate rows
foreach($items as $row_item) {
	$html.= "<tr>\n";
	// item id
	$html.= "<td class=\"h2b t2\" id=\"<!--item-->".$row_item['id']."<!--/item--><!--classification-->".$row_item['classification']."<!--/classification-->\">";
	$html.= $row_item['id'];
	$html.= "</td>\n";
	// Category
	$html.= "<td class=\"h2c t2\">";
	$html.= $row_item['category']."/<br/>".$row_item['category_sub'];
	$html.= "</td>\n";
	// Brand
	$html.= "<td class=\"h2c t2\" id=\"<!--brand-->\">";
	$html.= $row_item['brand'];
	$html.= "</td>\n";
	// Model
	$html.= "<td class=\"h2c t2\" id=\"<!--/brand--><!--model-->\">";
	$html.= $row_item['model'];
	$html.= "</td>\n";
	// description
	$html.= "<td class=\"h2c t2\" id=\"<!--/model--><!--description-->\">";
	$des = $row_item['description'];
	// budget
	if ($cfg['tender']['budget'] && $row_item['classification'] == "1") {
		if ($row_item['budget'] && $row_item['budget'] != "0.00") {
			$des.= " ".$this->lang['budgetamount']." : ".$cfg['local']['precurrency'].$row_item['budget'].$cfg['local']['postcurrency'];
		}
	}
	$html.= "<pre class=\"t2\">".wordwrap($des,25)."</pre>";
	$html.= "</td>\n";
	// Validity period
	$html.= "<td class=\"h2c t2\" id=\"<!--/description--><!--valid-->\">";
	$html.= $cfg['tender']['validity']['default']." ".$this->lang['days'];
	$html.= "</td>\n";
	// stock
	$html.= "<td class=\"h2c t2\" id=\"<!--/valid--><!--stock-->\">";
	$html.= "1 ".$this->lang['day'];
	$html.= "</td>\n";
	// item price
	$html.= "<td class=\"h2c t2\" id=\"<!--/stock--><!--price-->\">";
	if($row_item['price']) {
		$html.= $cfg['local']['precurrency'].$row_item['price'].$cfg['local']['postcurrency'];
	} else {
		$html.= $cfg['local']['precurrency']."0.00".$cfg['local']['postcurrency'];
	}
	$html.= "</td>\n";
	// clsoing column - must be present as outlook removes last tag in certain circumstances
	$html.= "<td id=\"<!--/price-->\">";
	$html.= "</td>\n";
	$html.= "</tr>\n";
}
// Close the table
$html.= "</table>";
$html.= "<br/>";
// User manual
$html.= $this->lang['tosubmitreply'];
$html.= "<ol>";
foreach($this->lang['completeinst'] as $inst) {
	if($inst) {
		$html.= "<li>".$inst."</li>";
	}
}
$html.= "</ol>";

$html.= "<b>".$this->lang['note']."</b> : ".$this->lang['minperiod']." ".$cfg['tender']['validity']['minimum']." ".$this->lang['days'].".<br/>";
$html.= "<b>".$this->lang['note']."</b> : ".$this->lang['onlylarger']." ".$cfg['local']['precurrency']."0.00".$cfg['local']['postcurrency']." ".$this->lang['canbeincluded'].".<br/><br/>";
$html.= $this->lang['aftercompleting'];
$html.= " <a href=\"".$cfg['url']."manuals/".$agent['language']."/demo_message.html\">".$this->lang['clicktoview']."</a>";
$html.= "<br/><br/>";
// URL to complete online
$html.= $this->lang['youcanalso']." <a href=\"".$cfg['url']."index.php\">".$this->lang['completelogin']."</a>.";
$html.= "<br/><br/>";
// VAT
$html.= $this->lang['includesvat'];
$html.= "<br/><br/>";
// help
$html.= $this->lang['problemswith'];
$html.= " <a href=\"".$cfg['url']."manuals/".$agent['language']."/supplier_manual.pdf\">".$this->lang['downloadmanual']."</a>.";
$html.= "<br/><br/>";
// Disclaimer 1
$html.= $this->lang['disclaimer1'];
?>
