<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create user
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required[0]['classification'] = "3";
$required[0]['permission'] = "all";
// agent/subscriber permission
$required[1]['classification'] = array("1","2");
$required[1]['permission'] = array("2","3","4");

// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require($cfg['file'].'modules/password/class/password.class.php');
	require($cfg['file'].'modules/generic/class/message.class.php');
	require($cfg['file'].'modules/generic/class/file.class.php');
	require($cfg['file'].'modules/external/class/smtp/htmlMimeMail.php');
	// instantiate the xml object
	$new_users = new user;
	$new_file = new file;
	if(!$params['show']) {
		$new_branch = new branch;
		// organisation and branch info
		$branch_info = $new_branch->get_info($params['currentinfo'][0]['branchid'],$cfg,$conn);
		if($params['currentinfo'][0]['organisationid'] == $branch_info['organisation']) {
			// parse parameters info
			$users = $new_users->parse_info($params['currentinfo'][0],$user,$cfg);
			if(!empty($new_user->error)) {
				$errors = array_merge($errors,$new_user->error);	
			}
			if($users) {
				// insert user into database
				if($users['id'] = $new_users->create_user($users,$cfg,$conn)) {
					$xml_params['created'] = "1";
					$new_password = new password;
					$new_password->send_password($users,$user['id'],$cfg,$conn);
				}
				// resend old infomation
				$xml_params['language'] = $params['language'];
				$xml_params['theme'] = $params['theme'];
				if(!empty($new_users->error)) {
					$errors = array_merge($errors,$new_users->error); 	
				}
				if(!empty($new_password->error)) {
					$errors = array_merge($errors,$new_password->error); 	
				}
				if($users['id']) {
					// not editable
					$xml_params['editable'] = "0";
					$xml_params['admineditable'] = "0";
					$xml_params['userinfo'][0] = $new_users->get_profile($users,$cfg,$conn);
				} else {
					// not editable
					$xml_params['currentinfo'] = $params['currentinfo'];
					$xml_params['branchid'] = $params['branchid'];
					$xml_params['organisationid'] = $params['organisationid'];
				}
			}
			$module = "user";
			if($xml_params['created'] == "1") {
				$page = "profile";
			} else {
				$page = "create";
			}
			if(!empty($new_user->error)) {
				$errors = array_merge($errors,$new_user->error);	
			}
			if($users['classification'] == "1") {
				$page.="_agent";
			} elseif($users['classification'] == "2") {
				$page.="_subscriber";
			} elseif($users['classification'] == "3") {
				$page.="_admin";
			} else {
				$page = "error";
				$module = "generic";
			}
			// look for addition fields
			$new_file->link_api_find("user",$page,$xml_params,$user,$cfg,$conn);
			// generate xml
			$xml = $new_xml->xml_generator($module,$page,$errors,$xml_params,$user,$cfg);
		} else {
			// branch organisation id does not match organisation id
			$new_branch->error[] = "e34";
			// generate xml
			$xml = $new_xml->xml_generator($module,"error",$new_branch->error,"",$user,$cfg);
		}
	} else {
		$module = "user";
		$page = "create";
		if($params['currentinfo'][0]['classification'] == "1") {
			$page.="_agent";
		} elseif($params['currentinfo'][0]['classification'] == "2") {
			$page.="_subscriber";
		} elseif($params['currentinfo'][0]['classification'] == "3") {
			$page.="_admin";
		} else {
			$params['errors'][] = "82";
			$page = "error";
			$module = "generic";
		}
		$new_branch = new branch;
		// organisation and branch info
		$xml_params['branchid'] = $params['branchid'];
		$branch_info = $new_branch->get_info($params['branchid'],$cfg,$conn);
		// check branch and organisation
		if($branch_info['organisation'] == $params['organisationid']) {
			$xml_params['organisationid'] = $params['organisationid'];
			// language and theme infomation
			$xml_params['language'] = $params['language'];
			$xml_params['theme'] = $params['theme'];
			$info['searchinfo']['organisationid'] = $params['organisationid'];
			$xml_params['users'] = $new_users->search($info,$cfg,$conn);
			// mandate 
			$xml_params['currentinfo'] = $params['currentinfo'];
			if(!$xml_params['currentinfo'][0]['phone_work']) {
				$xml_params['currentinfo'][0]['phone_work'] = $branch_info['phone_work'];
			}
			if(!$xml_params['currentinfo'][0]['phone_prefix']) {
				$xml_params['currentinfo'][0]['phone_prefix'] = $branch_info['phone_prefix'];
			}
			if(!$xml_params['currentinfo'][0]['phone_fax']) {
				$xml_params['currentinfo'][0]['phone_fax'] = $branch_info['phone_fax'];
			}
			if(!$xml_params['currentinfo'][0]['email']) {
				$xml_params['currentinfo'][0]['email'] = $branch_info['email'];
			}
			// look for addition fields
			$new_file->link_api_find("user",$page,$xml_params,$user,$cfg,$conn);
			// generate xml
			$xml = $new_xml->xml_generator($module,$page,$params['errors'],$xml_params,$user,$cfg);
		} else {
			// branch organisation id does not match organisation id
			$params['errors'][] = "e34";
			// generate xml
			$xml = $new_xml->xml_generator($module,"error",$params['errors'],"",$user,$cfg);
		}
	}
}
?>