<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* User profile
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

// instantiate the xml object
$new_xml = new xml;
// set the required type and permission required
$required['classification'] = "all";
$required['permission'] = "all";
// Security - determine if user authorised to perform transaction
$authorised = $new_security->permission_authentication($required,$user,$cfg);
// unauthorised user
if (!$authorised) {
	// instantiate the error class
	$new_error = new error;
	// proses the reponse error
	$xml = $new_error->response_xml($new_security->error,$user,$cfg);
} else {
	require($cfg['file'].'modules/generic/class/file.class.php');
	// instantiate object
	$new_users = new user;
	// check profile id 
	if(!$params['id']) {
		$params['id'] = $user['id'];
	}
	// instantiate object
	$new_file = new file;
	$xml_params['availabletheme'] = $params['theme'];
	$xml_params['availablelang'] = $params['language'];
	// get user profile 
	$xml_params['userinfo'][0] = $new_users->get_profile($params,$cfg,$conn);
	// assume not editable
	$xml_params['editable'] = "0";
	$xml_params['admineditable'] = "0";
	// check if user is editable
	if($xml_params['userinfo'][0]['status'] == "0") {
		// no one may edit
		$xml_params['editable'] = "0";
		$xml_params['admineditable'] = "0";
	} elseif($user['classification'] == "3" && $user['permission'] == "2") {
		// super administrator can edit
		$xml_params['editable'] = "1";
		$xml_params['admineditable'] = "1";
	} elseif($user['classification'] == "3" && $xml_params['userinfo'][0]['classification'] != "3") {
		// normal administrator can edit
		$xml_params['editable'] = "1";
		$xml_params['admineditable'] = "1";
	} elseif($user['permission'] > $xml_params['userinfo'][0]['permission']) {
		if($user['classification'] == "1" && $user['permission'] == "2") {
			// super agent can edit
			$xml_params['editable'] = "1";
		} elseif ($user['classification'] == "2") {
			if($user['permission'] == "4" && $user['organisation'] == $xml_params['userinfo'][0]['organisationid']) {
				// organisational user can edit
				$xml_params['editable'] = "1";
				$xml_params['admineditable'] = "1";
			} elseif($user['permission'] == "2" && $user['branch'] == $xml_params['userinfo'][0]['branchid']) {
				// branch user can edit
				$xml_params['editable'] = "1";
				$xml_params['admineditable'] = "1";
			}
		}
	} elseif($user['id'] == $xml_params['userinfo'][0]['id']) {
		// self can edit
		$xml_params['editable'] = "1";
		$xml_params['admineditable'] = "0";
	}
	if($params['error'] || $new_users->error) {
		if(!empty($params['error'])) {
			$errors = array_merge($errors,$params['error']);
		}
		if(!empty($new_users->error)) {
			$errors = array_merge($errors,$$new_users->error);
		}
		// generate xml 
		$xml = $new_xml->xml_generator("admin","profile",$errors,$xml_params,$user,$cfg);
	} elseif($params['update'] && $params['id']) {
		// not allowed to changed organisation
		unset($params['update']['organisation']);
		// check permissions
		if ($xml_params['editable']) {
			// if deleting
			if($params['update']['status'] == "0") {
				$params['update']['deleted_by'] = $user['id'];
				$new_database = new database;
				$new_database->setTime("deleted",$params['update'],"",$cfg);
			}
			// create where clause 
			$params['where'] = " id = ".$params['id']." ";
			if($new_users->update_user($params,$cfg,$conn)) {
				if($params['update']['status'] != "0") {
					$xml_params['updated'] = "1";
				} else {
					$xml_params['deleted'] = "1";
					// no more editable , deleted
					$xml_params['editable'] = "0";
					$xml_params['admineditable'] = "0";
				}
			}
			// get user profile
			$xml_params['userinfo'][0] = $new_users->get_profile($params,$cfg,$conn);
			// keep errors
			$errors = $new_users->error;
		} else {
			// Insufficient authority 
			$errors[] = "1067";
		}
	} else {
		$new_organisation = new organisation;
		// check if viewable
		if($xml_params['editable']) {
			$viewable = TRUE;
		} elseif($user['organisation'] == $xml_params['userinfo'][0]['organisationid']) {
			// if from same organisation
			$viewable = TRUE;
		} elseif($user['classification'] == "1" && $xml_params['userinfo'][0]['classification'] == "2") {
			// if viewing subscriber infro and you are an agent
			$viewable = TRUE;
		} elseif($user['classification'] == "2" && $xml_params['userinfo'][0]['classification'] == "1") {
			// if viewing subscriber infro and you are an agent
			$viewable = TRUE;
		} elseif($user['classification'] == "3") {
			$viewable = TRUE;
		}
		// keep errors
		$errors = $new_organisation->error;
		if(!$viewable) {
			// Insufficient authority 
			$errors[] = "1067";
			unset($xml_params['userinfo'][0]);
		}
	}
	if($xml_params['admineditable']) {
		$info['searchinfo']['organisationid'] = $xml_params['userinfo'][0]['organisationid'];
		$new_branch = new branch;
		$xml_params['branch'] = $new_branch->search($info,$cfg,$conn);
	}
	if($xml_params['userinfo'][0]['classification'] == "3") {
		// generate xml
		// look for addition fields
		$new_file->link_api_find("user","profile_admin",$xml_params,$user,$cfg,$conn); 
		$xml = $new_xml->xml_generator("user","profile_admin",$errors,$xml_params,$user,$cfg);
	} elseif($xml_params['userinfo'][0]['classification'] == "2") {
		if($xml_params['admineditable']) {
			// search for available administrators
			$info['searchinfo']['organisationid'] = $xml_params['userinfo'][0]['organisationid'];
			// exclude self
			$info['searchinfo']['exclude_usersid'] = $xml_params['userinfo'][0]['id'];
			$xml_params['users'] = $new_users->search($info,$cfg,$conn);
			unset($info);
			$info['searchinfo']['classification'] = "3";
			$result = $new_users->search($info,$cfg,$conn);
			if(is_array($result)) {
				$xml_params['users'] = array_merge($xml_params['users'],$result);
			}
		}
		// join errors
		if(!empty($new_users->error)) {
			$errors = array_merge($errors,$new_users->error);
		}
		// look for addition fields
		$new_file->link_api_find("user","profile_subscriber",$xml_params,$user,$cfg,$conn);
		// generate xml 
		$xml = $new_xml->xml_generator("user","profile_subscriber",$errors,$xml_params,$user,$cfg);
	} elseif($xml_params['userinfo'][0]['classification'] == "1") {
		// look for addition fields
		$new_file->link_api_find("user","profile_agent",$xml_params,$user,$cfg,$conn);
		// generate xml 
		$xml = $new_xml->xml_generator("user","profile_agent",$errors,$xml_params,$user,$cfg);
	} else {
		// generate xml 
		$xml = $new_xml->xml_generator("user","error",$errors,$xml_params,$user,$cfg);
	}
}
?>