<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* User agent class
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

Class agent extends user {

	/**
	 * Get Control panel information for agent
	 * 
	 * @param array new_session session class
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array Control Panel information  
	 */
	function get_control($new_session,$cfg,$conn) {
		// instantiate object
		$new_report = new detail;
		$info['searchinfo']['tenderstatus'] = "2";
		$info['searchinfo']['agentid'] = $new_session->user['id'];
		if($tenders = $new_report->search_request($info,$cfg,$conn)) {
			$xml_params['opentenderscount'] = count($tenders);
		} else {
			$xml_params['opentenderscount'] = 0;
		}
		$xml_params['opentenders'] = $tenders;
		$xml_params['quotedtenders'] = $new_report->search_quote_count($info,$cfg,$conn);
		return $xml_params;
	}
}
?>