<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* User class
* @package TenderSystem
* @subpackage user
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}
	
Class user {
	// user paramaters
	var $user;
	var $error;
	var $cache;
	
	function user() {
		// allow php5 to work
		$this->error = array();
	}
	
	/**
	 * Create a new user
	 * 
	 * @param array params user information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array Control Panel information  
	 */
	function create_user($params,$cfg,$conn){
		$this->user = $params;
		// Check if main parameters exist 
		if (!$this->user['username']){
			// missing username
			$this->error[] = "94";
		} else {
			// lower case username
			$this->user['username'] = strtolower($this->user['username']);	
		}
		if(strlen($this->user['username']) < 5) {
			// user name to short
			$this->error[] = "262";
		}
		if($this->get_id_by_username($this->user['username'],$cfg,$conn)) {
			// Already exists
			$this->error[] = "267";
		}
		
		if (!$this->user['name']){
			// missing first name
			$this->error[] = "96";
		}
		if (!$this->user['surname']){
			// missing surname
			$this->error[] = "88";
		}
		if (!$this->user['permission']){
			// Missing permission
			$this->error[] = "237";
		}
		if (!$this->user['classification']){
			// Missing type
			$this->error[] = "82";
		}
		if (!$this->user['administrator']){
			// Missing administrator
			$this->error[] = "238";
		}
		if (!$this->user['theme']){
			// missing theme
			$this->error[] = "100";
		}
		if (!$this->user['language']){
			// missing language 
			$this->error[] = "101";
		}
		if (!$this->user['created_by']) {
			// missing created by
			$this->error[] = "239";
		}
		if (!$this->user['password_key']) {
			// missing password
			$this->user['password_key'] = "none";
		}
		// errors 
		if (!empty($this->error)) {
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		}
		$new_database = new database;
		$table_name = "~users";
		// no id 
		if(!$this->user['id']) {
			// generate an id 
			$this->user['id'] = $new_database->get_next_id($table_name,$cfg,$conn);
		}
		$new_database->setTime("created",$this->user,"",$cfg);
		$new_database->parse_sql($table_name,$cfg);
		// execute
		$conn->AutoExecute($table_name,$this->user,"INSERT");
	    if ($conn->ErrorMsg()) {
	    	// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while inserting into database 
			$this->error[] = "1064";
			// response
			return FALSE;
      	}
      	// response
		return $this->user['id'];
	}
	
	/**
	 * updates user information
	 * 
	 * @param array params user information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array TRUE on succes and FALSE on failure
	 */
	function update_user($params,$cfg,$conn) {
		$new_database = new database;
		if(!$new_database->update_table("~users",$params['update'],$params['where'],$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		} 
      	return TRUE;
	}
	
	/**
	 * search for users
	 * 
	 * @param array params search information
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array TRUE on succes and FALSE on failure
	 */
	function search($params,$cfg,$conn) {
		$sqlstr = "SELECT ~users.id AS usersid, ~users.name AS name, ~users.surname AS surname,";
		$sqlstr.= "~users.username, ~users.email, ~users.preference, ";
		if($params['searchinfo']['extrainfo']) {
			$sqlstr.= "~users.phone_work, ~users.status, ~users.phone_prefix, ";
			$sqlstr.= "~users.organisation AS organisationid, ~users.branch AS branchid, "; 
		}
		$sqlstr.= "branch.id AS branchid "; 
		$sqlstr.= "FROM ~users, ~organisation_branch branch, ~organisation ";
		$sqlstr.= "WHERE ~users.status > 0 ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		$sqlstr.= "AND branch.status = '1' ";
		$sqlstr.= "AND ~users.organisation =  ~organisation.id ";
		$sqlstr.= "AND ~organisation.status = '1' ";
		if($params['searchinfo']['classification']) {
			$sqlstr.= "AND ~users. classification = '".$params['searchinfo']['classification']."' ";
		}
		if($params['searchinfo']['usersid']) {
			$sqlstr.= "AND ~users.id = '".$params['searchinfo']['usersid']."' ";
		}
		if($params['searchinfo']['exclude_usersid']) {
			$sqlstr.= "AND ~users.id != '".$params['searchinfo']['exclude_usersid']."' ";
		}
		if($params['searchinfo']['organisationid']) {
			$sqlstr.= "AND ~users.organisation = '".$params['searchinfo']['organisationid']."' ";
		}
		if($params['searchinfo']['branchid']) {
			$sqlstr.= "AND ~users.branch = '".$params['searchinfo']['branchid']."' ";
		}
		if($params['searchinfo']['searchvalue']) {
			$sqlstr.= "AND ~users.name LIKE %".$params['searchinfo']['searchvalue']."% ";
		}
		if($params['searchinfo']['usersusername']) {
			$sqlstr.= "AND ~users.username = '".$params['searchinfo']['usersusername']."' ";
		}
		$sqlstr.= "ORDER BY ~users.name ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		if($params['searchinfo']['extrainfo']) {
			$new_branch = new branch;
			$new_organisation = new organisation;
			foreach($all as $key => $value) {
				$branchinfo = $new_branch->get_info($value['branchid'],$cfg,$conn);
				$all[$key]['branchname'] = $branchinfo['name'];
				$organisationinfo = $new_organisation->get_info($value['organisationid'],$cfg,$conn);
				$all[$key]['organisationname'] = $organisationinfo['name'];
			}
		}
		return $all;
	}

	/**
	 * parse user create information
	 * 
	 * @param array info User Create information
	 * @param array info Creator's User Information
	 * @param mixed cfg The Config settings of tendersystem
	 *
	 * @param array TRUE on succes and FALSE on failure
	 */
	function parse_info($info,$user,$cfg) {
		// user info 
		$users['username'] = str_replace(" ","",$info['username']);
		$users['name'] = $info['name'];
		$users['surname'] = $info['surname'];
		$users['phone_prefix'] = $info['phone_prefix'];
		$users['phone_work'] = $info['phone_work'];
		$users['phone_fax'] = $info['phone_fax'];
		$users['phone_mobile'] = $info['phone_mobile'];
		$users['email'] = $info['email'];
		$users['preference'] = $info['preference'];
		$users['skype'] = $info['skype'];
		$users['date_of_birth'] = $info['date_of_birth'];
		$users['im_contact'] = $info['im_contact'];
		$users['instant_messager'] = $info['instant_messager'];
		$users['emailimages'] = $info['emailimages'];
		if($user['classification'] != "3") {
			$users['classification'] = $user['classification'];
		} else {
			$users['classification'] = $info['classification'];
		}
		$users['theme'] = $info['theme'];
		$users['language'] = $info['lang'];
		$users['mandate'] =  $info['mandate'];
		$users['status'] = "2";
		if($user['classification'] == "3" && $user['permission'] == "2") {
			$users['permission'] = $info['permission'];
		} elseif($user['classification'] == "3" && $users['classification'] != "3") {
			$users['permission'] = $info['permission'];
		} else {
			$users['permission'] = min($info['permission'],$user['permission']);
		}
		$users['organisation'] = $info['organisationid'];
		if(!$users['organisation'] || $user['classification'] != "3") {
			$users['organisation'] = $user['organisation'];
		}
		$users['branch'] = $info['branchid'];
		if(!$users['branch'] || ($user['classification'] != "3" && $user['permission'] < 3)) {
			$users['branch'] = $user['branch'];
		}
		if(!$users['branch']) {
			$users['branch'] = $user['branch'];
		}
		if(!$users['organisation']) {
			$users['organisation'] = $user['organisation'];
		}
		// created by
		$users['created_by'] = $user['id'];
		// administrator
		$users['administrator'] = $info['administrator'];
		if(!$users['administrator']) {
			$users['administrator'] = $user['id'];
		}
		if(is_array($info['additional'])) {
			foreach($info['additional'] as $key => $value) {
				$users[$key] = $value;	
			}
		}
		// remove null values
		foreach($users as $key => $value) {
			if(!$value) {
				unset($users[$key]);
			}
		}
		return $users;
	}

	/**
	 * get users profile
	 * 
	 * @param array params Users ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_profile($params,$cfg,$conn) {
		if(is_numeric($params)) {
			$this->user['id'] = $params;
		} else {
			$this->user = $params;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing user id
			$this->error[] = "209";
		}
		// errors 
		if(!empty($this->error)){
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		}
		$sqlstr = "SELECT users.id, users.name, users.surname, ";
		$sqlstr.= "users.organisation, users.branch, users.phone_work, ";
		$sqlstr.= "users.phone_fax, users.phone_mobile, users.email, ";
		$sqlstr.= "users.phone_prefix, users.theme, users.language, ";
		$sqlstr.= "users.administrator, users.status, users.preference,  ";
		$sqlstr.= "users.classification, users.permission, users.mandate, ";
		$sqlstr.= "users.created_date, users.created_time, users.created_by, ";
		$sqlstr.= "users.deleted_date, users.deleted_time, users.deleted_by, ";
		$sqlstr.= "users.im_contact, users.instant_messager, users.skype, ";
		$sqlstr.= "users.date_of_birth, users.emailimages,  ";
		$sqlstr.= "admins.name AS adminname, admins.surname AS adminsurname, admins.id AS adminid, ";
		$sqlstr.= "admins.email AS adminemail, ";
		$sqlstr.= "creators.name AS creatorname, creators.surname AS creatorsurname, ";
		$sqlstr.= "creators.id AS creatorid, ";
		$sqlstr.= "deleters.name AS deletername, deleters.surname AS deletersurname, ";
		$sqlstr.= "deleters.id AS deleterid ";
		$sqlstr.= "FROM ~users users LEFT JOIN ~users deleters ON deleters.id = users.deleted_by, ~users admins, ~users creators ";
		$sqlstr.= "WHERE users.id = ".$this->user['id']." "; 
		$sqlstr.= "AND users.administrator = admins.id ";
		$sqlstr.= "AND users.created_by = creators.id ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$row = $conn->GetRow($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		} elseif(!$row) {
			// Username does not exist
			$this->error[] = "214";
			// error in user class
			$this->error[] = "98";
			// response
			return FALSE;
		}
		$new_database->convertSingleTime($row,$cfg);
		$new_organisation = new organisation;
		// get organisation info
		$org_info = $new_organisation->get_info($row['organisation'],$cfg,$conn);
		if(!is_array($org_info)) {
			if(!empty($new_organisation->error)) {
				$this->error = array_merge($this->error,$new_organisation->error);
			}
			// Error in User class 
			$this->error[] = "98";
			// response
			return FALSE;
		}
		$row['organisationname'] = $org_info['name'];
		$row['orgstatus'] = $org_info['status'];
		$row['organisationid'] = $org_info['id'];
		$row['transaction_fee'] = $org_info['transaction_fee'];
		$row['transaction_min'] = $org_info['transaction_min'];
		$row['sms_fee'] = $org_info['sms_fee'];
		$row['user_fee'] = $org_info['user_fee'];
		$row['rating'] = $org_info['rating'];
		$row['vat_number'] = $org_info['vat_number'];
		$row['registration_number'] = $org_info['registration_number'];
		$new_branch = new branch;
		// get organisation info
		$branch = $new_branch->get_info($row['branch'],$cfg,$conn);
		if(!is_array($branch)) {
			if(!empty($new_branch->error)) {
				$this->error = array_merge($this->error,$new_branch->error);
			}
			
			// Error in User class 
			$this->error[] = "98";
			// response
			return FALSE;
		}
		$row['branchname'] = $branch['name'];
		$row['branchstatus'] = $branch['status'];
		$row['branchid'] = $branch['id'];
		$row['branchphone_prefix'] = $branch['phone_prefix'];
		$row['branchphone_work'] = $branch['phone_work'];
		$row['branchemail'] = $branch['email'];
		$row['branchphone_fax'] = $branch['phone_fax'];
		$row['branch_po_street'] = $branch['primary_address_street'];
		$row['branch_po_city'] = $branch['primary_address_city'];
		$row['branch_po_state'] = $branch['primary_address_state'];
		$row['branch_po_code'] = $branch['primary_address_postalcode'];
		$row['branch_po_country'] = $branch['primary_address_country'];
		$row['branch_ph_street'] = $branch['alt_address_street'];
		$row['branch_ph_city'] = $branch['alt_address_city'];
		$row['branch_ph_state'] = $branch['alt_address_state'];
		$row['branch_ph_code'] = $branch['alt_address_postalcode'];
		$row['branch_ph_country'] = $branch['alt_address_country'];
		$row['branchcomment'] = $branch['branch_comment'];
		return $row;
	}
	
	/**
	 * get users information
	 * 
	 * @param array params Users ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_info($params,$cfg,$conn) {
		if(is_numeric($params)) {
			$this->user['id'] = $params;
		} else {
			$this->user = $params;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing user id
			$this->error[] = "209";
		}
		// errors 
		if(!empty($this->error)){
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		}
		// check if in cache
		if($this->cache[$this->user['id']] && $cfg['user']['cache']) {
			// use cache
			return $this->cache[$this->user['id']];
		} else { 
			// get from database
			$sqlstr = "SELECT * ";
			$sqlstr.= "FROM ~users ";
			$sqlstr.= "WHERE ~users.id = ".$this->user['id']." "; 
			$new_database = new database;
			$new_database->parse_sql($sqlstr,$cfg);
			$this->cache[$this->user['id']] = $conn->GetRow($sqlstr,"",TRUE);
			if($conn->ErrorMsg()) {
				// instantiate the error class and log
				$new_error = new error;
				$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
				$new_error->log("SQL","critical",$error_text,$cfg);
				// error occurred while querying into database 
				$this->error[] = "1065";
				// response
				return FALSE;
			}
			return $this->cache[$this->user['id']];
		}
	}
	
	/**
	 * get sms message fee
	 * 
	 * @param array params Users ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_sms_cost($params,$cfg,$conn) {
		if(is_numeric($params)) {
			$this->user['id'] = $params;
		} else {
			$this->user = $params;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing user id
			$this->error[] = "209";
		}
		// errors 
		if(!empty($this->error)){
			// Error in User Class
			$this->error[] = "98";
			return "0";
		}
		$userinfo = $this->get_info($this->user['id'],$cfg,$conn);
		$new_organisation = new organisation;
		$orginfo = $new_organisation->get_info($userinfo['organisation'],$cfg,$conn);
		if($orginfo) {
			return $orginfo['sms_fee'];
		} else {
			return "0";
		}
	}
	
	/**
	 * get user theme
	 * 
	 * @param array params Users ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_theme($params,$cfg,$conn) {
		if(is_numeric($params)) {
			$this->user['id'] = $params;
		} else {
			$this->user = $params;
		}
		// Check if main parameters exist 
		if (!$this->user['id']){
			// Missing user id
			$this->error[] = "209";
		}
		// errors 
		if(!empty($this->error)){
			// Error in User Class
			$this->error[] = "98";
			return "0";
		}
		$userinfo = $this->get_info($this->user['id'],$cfg,$conn);
		return $userinfo['theme'];
	}
	
	/**
	 * get User ID from username
	 * 
	 * @param string username
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_id_by_username($username,$cfg,$conn,$any_status=FALSE) {
		// Check if main parameters exist 
		if (!$username){
			// Missing user name
			$this->error[] = "8";
		}
		// errors 
		if(!empty($this->error)){
			
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		}
		// SELECT
		$sqlstr = "SELECT ~users.id ";
		// FROM
		$sqlstr.= "FROM ~users, ~organisation, ~organisation_branch branch ";
		// WHERE
		$sqlstr.= "WHERE ~users.username = '".$username."' "; 
		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		if(!$any_status) {
			$sqlstr.= "AND branch.status = '1' ";
			$sqlstr.= "AND ~organisation.status = '1' ";
			$sqlstr.= "AND ~users.status > 0 ";
		}
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * get Users password
	 * 
	 * @param integer userid User's ID
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_password($userid,$cfg,$conn) {
		// Check if main parameters exist 
		if (!$userid){
			// Missing user id
			$this->error[] = "209";
		}
		// errors 
		if(!empty($this->error)){
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		}
		// SELECT
		$sqlstr = "SELECT ~users.password_key ";
		// FROM
		$sqlstr.= "FROM ~users, ~organisation, ~organisation_branch branch ";
		// WHERE
		$sqlstr.= "WHERE ~users.id = '".$userid."' "; 
		$sqlstr.= "AND ~users.organisation = ~organisation.id ";
		$sqlstr.= "AND ~users.branch = branch.id ";
		$sqlstr.= "AND branch.status = '1' ";
		$sqlstr.= "AND ~organisation.status = '1' ";
		$sqlstr.= "AND ~users.status > 0 ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$one = $conn->GetOne($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg()." SQL:".$sqlstr;
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		return $one;
	}
	
	/**
	 * update Users password
	 * 
	 * @param string users hashed password
	 * @param integer userid User's ID
	 * @param integer status new status of user
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on succes and FALSE on failure
	 */
	function update_password($password_key,$user_id,$status,$cfg,$conn) {
		$update = array(
			'password_key'	=> $password_key,
			'status'		=> $status
		);
		$where = "id = '".$user_id."' ";
		$new_database = new database;
		if(!$new_database->update_table("~users",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		} 
      	return TRUE;
	}
	
	/**
	 * set all active users to status 2
	 * 
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param boolean TRUE on succes and FALSE on failure
	 */
	function password_renew($cfg,$conn) {
		$update = array(
			'status' => '2'
		);
		$where = " status = 1 ";
		$new_database = new database;
		if(!$new_database->update_table("~users",$update,$where,$cfg,$conn)) {
			if(!empty($new_database->error)) {
				$this->error = array_merge($this->error,$new_database->error);
			}
			// Error in User Class
			$this->error[] = "98";
			return FALSE;
		} 
      	return TRUE;
	}
	
		/**
	 * get users profile
	 * 
	 * @param array params Month and Day
	 * @param mixed cfg The Config settings of tendersystem
	 * @param [ADOConnection] conn The connection to the database
	 *
	 * @param array User information or FALSE on error
	 */
	function get_birthdays($params,$cfg,$conn) {
		// set the paramaters
		$this->birthday = $params;
		// SQL query
		$sqlstr = "SELECT users.id, users.name, users.surname, ";
		$sqlstr.= "users.organisation, users.branch, users.phone_work, ";
		$sqlstr.= "users.phone_fax, users.phone_mobile, users.email, ";
		$sqlstr.= "users.phone_prefix, users.theme, users.language, ";
		$sqlstr.= "users.administrator, users.status, users.preference,  ";
		$sqlstr.= "users.classification, users.permission, users.mandate, ";
		$sqlstr.= "users.created_date, users.created_time, users.created_by, ";
		$sqlstr.= "users.im_contact, users.instant_messager, users.skype, ";
		$sqlstr.= "users.date_of_birth, users.emailimages  ";
		$sqlstr.= "FROM ~users users ";
		$sqlstr.= "WHERE users.status != '0' ";
		// if months is set
		if ($this->birthday['month']) {
			$sqlstr.= "AND EXTRACT(MONTH FROM users.date_of_birth) = '".$this->birthday['month']."' ";
		}
		// if date is set
		if ($this->birthday['day']) {
			$sqlstr.= "AND EXTRACT(DAY FROM users.date_of_birth) = '".$this->birthday['day']."' ";
		}
		$sqlstr.= "ORDER BY EXTRACT(DAY FROM users.date_of_birth) ASC ";
		$new_database = new database;
		$new_database->parse_sql($sqlstr,$cfg);
		$all = $conn->GetAll($sqlstr,"",TRUE);
		if($conn->ErrorMsg()) {
			// instantiate the error class and log
			$new_error = new error;
			$error_text = "SQL error in file ".__file__." on line ".__line__." Error:".$conn->ErrorMsg();
			$new_error->log("SQL","critical",$error_text,$cfg);
			// error occurred while querying into database 
			$this->error[] = "1065";
			// response
			return FALSE;
		}
		$new_database->convertTime($all,$cfg);
		return $all;
	}
}
?>