<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Password Reset Confirmation Page
* @package TenderSystem
* @subpackage password
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// load required files
require('modules/generic/generic.php');

// field request errors and type 
// 1037 - Missing Language
// e13 - Missing Password Reset ID
// 1038 - Missing User ID
// e14 - Missing User ID
$fields_request = array (
	'language'		=> array("1037"),
	'userid'		=> array("1038"),
	'id'			=> array("e13"),
	'auth_string'	=> array("e14")
);

if (get_request($fields_request,$info,$error,$cfg)) {
	// set paramaters
	$params = array(
		'module'			=> 'password',
		'function'			=> 'confirm',
		'language'			=> $info['language'],
		'id'				=> $info['id'],
		'user_id'			=> $info['userid'],
		'authentication'	=> $info['auth_string']
	);
	// send the message to app
	$data = send_message($params,$cfg);
} else {
	xml_generator('password','error',$error,$username,$cfg);
}
?>