<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create state
* @package TenderSystem
* @subpackage area
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'	=> array(),
	'upload'	=> array()
);
get_request($fields_request,$action,$error,$cfg);

if($action['upload']) {
	$params = array(
			'module'	=> 'area',
			'function'	=> 'create_state'
	);
	// field request errors and type 
	$fields_request = array (
		'state'		=> array(),
		'istate'	=> array(),
		'area'		=> array(),
		'iarea'		=> array()
	);
	get_request($fields_request,$info,$error,$cfg);
	// loop through each state
	foreach($info['state'] as $key => $value) {
		// check if state must be ignored
		if($info['istate'][$key] != "on" && $value) {
			$tmp_state['name'] = $value;
			// loop through each area
			foreach($info['area'][$key] as $key_a => $value_a) {
				// check if area must be ignored
				if($info['iarea'][$key][$key_a] != "on" && $value_a) {
					$tmp_state['area'][] = $value_a;
				}
			}
			$params['state'][] = $tmp_state;
			unset($tmp_state);
		}
	}
	// send the message to app
	send_message($params,$cfg);
} elseif ($action['action']) {
	// set the variables
	$file = $_FILES['file'];
	// field request errors and type 
	// e4 - Missing state name
	$fields_request = array (
		'state_name'	=> array("e4",	REQUEST_ANY,	"",	"",	"state"),
		'generic'		=> array()
	);
	// get info
	get_request($fields_request,$info,$error,$cfg);
	// determine if file must be uploaded
	if ($file['name'] || $info['generic']) {
		if($file['name']) {
			// upload the file
			$upload_dest = upload_file($file,"area",$cfg);
		} else {
			// upload the file
			$upload_dest = "./modules/area/language/".$_SESSION['ts_lang']."/areas/".$info['generic'].".xls";	
		}
		// send to the app
		if (is_string($upload_dest)) {
			// set file information
			$extension = substr(strrchr($upload_dest, "."), 1);
			if(!in_array($extension,array("xls"))) {
				// may not upload this filetype
				$error[] = "e3";
				// display error
				 xml_generator("area","create_state",$error,$params,$cfg);
			} else {
				// determine spreadsheet
				if($extension == "xls") {
					// read the excel spreadsheet
					$spreadsheet = read_excel($upload_dest,$cfg);
				}
				// set state counter
				$state_counter = -1;
				// loop through the spreedsheet values
				foreach($spreadsheet as $row => $values) {
					foreach($values as $col => $value) {
						if (!trim($value)) {
							continue;
						}
						if($col == "0") {
							// set state
							$params['state'][++$state_counter]['statename'] = $value;
							$area_counter = -1;
						} else {
							// set area
							$params['state'][$state_counter]['area'][++$area_counter]['areaname'] = $value;
						}
					}
				}
				// display message
				xml_generator("area","show_state_upload","",$params,$cfg);
			}
		} else {
			// display error
			xml_generator("area","create_state",$upload_dest['error'],$params,$cfg);
		}
	} elseif ($info['state']) {
		// parameters to send to the application server
		$state[]['name'] = $info['state'];
		$params = array(
			'module'	=> 'area',
			'function'	=> 'create_state',
			'state'		=> $state
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		// display error
		 xml_generator("area","create_state",$error,$params,$cfg);
	}
} else { 
	// generic states
	$dir = opendir("./modules/area/language/".$_SESSION['ts_lang']."/areas");
	// if folder accessible
	if ($dir) {
		// loop through all the files
		while(($file=readdir($dir)) !== FALSE) {
			// determine if hidden file not included
			if($file{0} != "." && $file != "CVS" && substr(strrchr($file, "."), 1) == "xls") {
				// set files in an array
				$params['generic'][] = basename($file, ".xls");
			}
		}
	}
	// close the directory
	closedir($dir);
	// display message
	xml_generator("area","create_state","",$params,$cfg);
}
?>