<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/create"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/area"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'area'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="area"/>
					<input type="hidden" name="function" value="create_area"/>
					<input type="hidden" name="stateid">
						<xsl:attribute name="value">
							<xsl:value-of select="stateid"/>
						</xsl:attribute>
					</input>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="created='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/createdarea"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="exist_area">
							<tr>
								<td class="h e" colspan="2">
									<xsl:value-of select="$lng/existarea"/>
								</td>
							</tr>
							<xsl:for-each select="exist_area">
								<tr>
									<td class="t1" colspan="2">
										<xsl:value-of select="name"/>
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<tr>
							<td class="t1" align="left">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="t2" align="left">
								<input type="text" name="areaname" size="12" value="" maxlenght="32" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1"></td>
							<td class="t1" align="left">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/instheader"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/inst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		<xsl:if test="created='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
