<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data" action="left.php?module=useradmin&amp;function=search" method="post" name="report">
						<table id="left" border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td class="t1">
									<a href="main.php?module=area&amp;function=create_state" target="main"><xsl:value-of select="$lng/create"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/state"/></a>
								</td>
							</tr>
							<xsl:if test="state/stateid">
								<tr>
									<td class="t2">
										<select name="state" class="t1" onchange="update()">
											<option value="0"><xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/state"/></option>
											<xsl:variable name="statematchid" select="stateid"/>
											<xsl:for-each select="state">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="./stateid"/></xsl:attribute>
													<xsl:if test="./stateid=$statematchid">
														<xsl:attribute name="selected">selected</xsl:attribute> 
													</xsl:if>
													<xsl:value-of select="statename"/>
												</option>		
											</xsl:for-each> 
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/state"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/admin"/>
										<ul>
											<li>
												<a href="#" onclick="remove('state','delete')"><xsl:value-of select="$lng/delete"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/state"/></a>
											</li>
										</ul>
									</td>
								</tr>
								<tr>
									<td class="t1">
										<a href="#" onclick="create('area')"><xsl:value-of select="$lng/create"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/area"/></a>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="area/areaid">
								<tr>
									<td class="t2">
										<select name="area" class="t1">
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/area"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/admin"/>
										<ul>
											<li>
												<a href="#" onclick="remove('area','delete')"><xsl:value-of select="$lng/delete"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/area"/></a>
											</li>
										</ul>
									</td>
								</tr>
							</xsl:if>
						</table>
					</form>
					<script language="javascript">
						function remove(myModule,myFunction) {	
							var myIndex = eval('document.report.'+myModule+'.selectedIndex');
							var name = eval('document.report.'+myModule+'.options[myIndex].text');
							var id = eval('document.report.'+myModule+'.value');
							if (myIndex) {
								if(confirm("Delete "+name)) {
									parent.main.location.href = "main.php?module=area&amp;function="+myFunction+"_"+myModule+"&amp;stateid="+id+"&amp;areaid="+id;
								}
							} else {
								if(myModule == "state") {
									alert("<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/state"/>");
								}
					<xsl:if test="area/areaid">
								if(myModule == "area") {
									alert("<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/area"/>");
								}
					</xsl:if>
								
							}
						}
				
						function create(Type) {	
					<xsl:if test="state/stateid">
							var stateIndex = document.report.state.selectedIndex;
							var stateid = document.report.state.value;
							if (stateIndex) {
								parent.main.location.href = "main.php?module=area&amp;function=create_area&amp;stateid="+stateid;
							} else {
								alert("<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/state"/>");
							}
					</xsl:if>
						}
					
						function update() {	
					<xsl:if test="state/stateid">
							var stateIndex = document.report.state.selectedIndex;
							var stateValue = document.report.state.value;
						<xsl:if test="area/areaid">
							var areaSelect = document.report.area;
							var areaOptions = areaSelect.options;
							var counter = 0;
							areaSelect.length = 0;
							areaOptions[counter++] = new Option("<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/area"/>","");
							<xsl:for-each select="area">
							if (stateValue == "<xsl:value-of select="./stateid"/>" || stateValue == "0") {
								areaOptions[counter++] = new Option("<xsl:value-of select="areaname"/>","<xsl:value-of select="areaid"/>");
							}
							</xsl:for-each>
							if(counter == 1) {
								areaSelect.disabled = 1;
							} else {
								areaSelect.disabled = 0;
							}
						</xsl:if>
					</xsl:if>
						}
						update();
					</script>
				</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>