<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="state_field">
	<xsl:param name="onchange" select="'update_state()'"/>
	<xsl:param name="fieldname" select="'state'"/>
	<xsl:param name="state" select="tender/state"/>
	<tr>
		<td class="t1"><xsl:value-of select="$lng/state"/></td>
		<td class="t2">
			<xsl:call-template name="state_select">
				<xsl:with-param name="onchange" select="$onchange"/>
				<xsl:with-param name="fieldname" select="$fieldname"/>
				<xsl:with-param name="state" select="$state"/>
			</xsl:call-template>
		</td>
	</tr>
</xsl:template>

<xsl:template name="area_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'area'"/>
	<xsl:param name="area" select="tender/area"/>
	<tr>
		<td class="t1"><xsl:value-of select="$lng/area"/></td>
		<td class="t2">
			<xsl:call-template name="area_select">
				<xsl:with-param name="onchange" select="$onchange"/>
				<xsl:with-param name="fieldname" select="$fieldname"/>
				<xsl:with-param name="area" select="$area"/>
			</xsl:call-template>
		</td>
	</tr>
</xsl:template>
	
<xsl:template name="area_select">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'area'"/>
	<xsl:param name="area" select="tender/area"/>
	<select name="{$fieldname}" class="t2" onchange="{$onchange}"/>
</xsl:template>
	
<xsl:template name="state_select">
	<xsl:param name="onchange" select="'update_state()'"/>
	<xsl:param name="fieldname" select="'state'"/>
	<xsl:param name="state" select="tender/state"/>
	<select name="{$fieldname}" class="t2" onchange="{$onchange}">
		<option value=""><xsl:value-of select="$lng/selectstate"/></option>
	<xsl:for-each select="state">
		<option value="{stateid}">
		<xsl:if test="stateid=$state">
			<xsl:attribute name="selected"/>
		</xsl:if>
			<xsl:value-of select="statename"/>
		</option>
	</xsl:for-each>
	</select>
</xsl:template>

<xsl:template name="state_script">
	<xsl:param name="functionname" select="'update_state'"/>
	<xsl:param name="selectstate" select="'state'"/>
	<xsl:param name="selectarea" select="'area'"/>
	<xsl:param name="zerooption" select="'yes'"/>
	function <xsl:value-of select="$functionname"/>() {	
<xsl:if test="state/stateid">
		var stateIndex = document.report.<xsl:value-of select="$selectstate"/>.selectedIndex;
		var stateValue = document.report.<xsl:value-of select="$selectstate"/>.value;
	<xsl:if test="area/areaid">
		var areaSelect = document.report.<xsl:value-of select="$selectarea"/>;
		var areaOptions = areaSelect.options;
		var counter = 0;
		areaSelect.length = 0;
		<xsl:if test="$zerooption='yes' or $zerooption='1'">
		areaOptions[counter++] = new Option("<xsl:value-of select="$lng/selectarea"/>","");
		</xsl:if>
		<xsl:for-each select="area">
		if (stateValue == "<xsl:value-of select="./stateid"/>" || stateValue == "0") {
			areaOptions[counter++] = new Option("<xsl:value-of select="areaname"/>","<xsl:value-of select="areaid"/>");
		}
		</xsl:for-each>
		<xsl:if test="$zerooption='yes' or $zerooption='1'">
		if(counter == 1) {
			areaSelect.disabled = 1;
		} else {
			areaSelect.disabled = 0;
		}
		</xsl:if>
		<xsl:if test="$zerooption!='yes' and $zerooption!='1'">
		if(counter == 0) {
			areaSelect.disabled = 1;
		} else {
			areaSelect.disabled = 0;
		}
		</xsl:if>
	</xsl:if>
</xsl:if>
	}
</xsl:template>

</xsl:stylesheet>