<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/birthdays"/>
		</div>
		<div id="content">
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="birthday"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td colspan="8" class="t1">
								<xsl:value-of select="$lng/annual"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/birthdays"/>
							</td>
						</tr>
						<tr>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=1"><xsl:value-of select="$lng/month1"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=2"><xsl:value-of select="$lng/month2"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=3"><xsl:value-of select="$lng/month3"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month1/birthday">
							<xsl:for-each select="month1/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month2/birthday">
							<xsl:for-each select="month2/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month3/birthday">
							<xsl:for-each select="month3/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=4"><xsl:value-of select="$lng/month4"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=5"><xsl:value-of select="$lng/month5"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=6"><xsl:value-of select="$lng/month6"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month4/birthday">
							<xsl:for-each select="month4/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month5/birthday">
							<xsl:for-each select="month5/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month6/birthday">
							<xsl:for-each select="month6/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=7"><xsl:value-of select="$lng/month7"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=8"><xsl:value-of select="$lng/month8"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=9"><xsl:value-of select="$lng/month9"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month7/birthday">
							<xsl:for-each select="month7/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month8/birthday">
							<xsl:for-each select="month8/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month9/birthday">
							<xsl:for-each select="month9/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=10"><xsl:value-of select="$lng/month10"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=11"><xsl:value-of select="$lng/month11"/></a>
							</td>
							<td><br/></td>
							<td class="h1 t1">
								<a href="main.php?module=birthday&amp;function=utilities&amp;view=month&amp;month=12"><xsl:value-of select="$lng/month12"/></a>
							</td>
						</tr>
						<tr>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month10/birthday">
							<xsl:for-each select="month10/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month11/birthday">
							<xsl:for-each select="month11/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
							<td><br/></td>
							<td class="h2b" valign="top" nowrap="nowrap">
						<xsl:if test="month12/birthday">
							<xsl:for-each select="month12/birthday">
								<xsl:value-of select="substring(date_of_birth,9)"/>
								<xsl:value-of select="' '"/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
								<xsl:value-of select="' '"/>
								(<a target="main">
									<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
									<xsl:value-of select="$lng/email"/>
								</a>)<br/>
							</xsl:for-each>
						</xsl:if>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/birthday"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/birthdayinst"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
