<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'category'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="category"/>
					<input type="hidden" name="function" value="show_brand"/>
					<input type="hidden" name="categoryid" value="{categoryid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/sun"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/mon"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/tue"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/wed"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/thu"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/fri"/>
							</td>
							<td></td>
							<td class="h t1" colspan="2">
									<xsl:value-of select="$lng/sat"/>
							</td>
						</tr>
						<tr>
							<td colspan="13"><br/></td>
						</tr>
			<xsl:for-each select="day[position() mod 7 = 1]">
						<tr>
				<xsl:for-each select=".|following-sibling::day[position() &lt; 7]">
					<xsl:choose>
						<xsl:when test="date > 0">
								<td class="h1" valign="top">
									<xsl:value-of select="date"/>
								</td>
								<td class="h2a" nowrap="nowrap" valign="top">
							<xsl:if test="birthday">
								<xsl:for-each select="birthday">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
									<xsl:value-of select="' '"/>
									(<a target="main">
										<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/happy"/><xsl:value-of select="' '"/><xsl:value-of select="name"/></xsl:attribute>
										<xsl:value-of select="$lng/email"/>
									</a>)<br/>
								</xsl:for-each>
							</xsl:if>
								</td>
								<td><br/></td>
						</xsl:when>
						<xsl:otherwise>
								<td colspan="3"><br/></td>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
						</tr>
						<tr>
							<td colspan="13"><br/></td>
						</tr>
			</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
