<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create branch
* @package TenderSystem
* @subpackage branch
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'createbranch'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if($action['createbranch']) {
	// field request errors and type
	// e5 - Missing branch comment
	// e6 - Missing postal's address street
	// e7 - Missing postal's address city
	// e8 - Missing postal's postal code
	// e9 - Missing postal's state
	// e11 - Missing physical address street
	// e12 - Missing physical address city
	// e13 - Missing physical postal code
	// e14 - Missing physical state
	// e16 - Missing branch name 
	// e18 - Missing country
	// 1002 - Organisation ID must be a number
	// 1017 - Phone Prefix must be a Number
	// 1018 - Phone Work not correctly formated
	// 1019 - Phone Fax not correctly formated
	// 1021 - Email not correctly formated
	// 1047 - Missing Organisation ID
	// 1048 - Missing Phone Prefix"
	// 1049 - Missing Phone Work
	// 1050 - Missing Phone Fax
	// 1052 - Missing Email Address
	$fields_request = array (
		'organisationid'				=> array("1047",	REQUEST_NUMBER,	FORMAT_NONE,	"1002"),
		'branchname'					=> array("e16"),
		'branchphone_work'				=> array("1048",	REQUEST_PHONE,	FORMAT_PHONE,	"1018"),
		'branchphone_prefix'			=> array("1048",	REQUEST_NUMBER,	FORMAT_NONE,	"1017"),
		'branchphone_fax'				=> array("1050",	REQUEST_PHONE,	FORMAT_PHONE,	"1019"),
		'branchemail'					=> array("1052",	REQUEST_EMAIL,	FORMAT_NONE,	"1021"),
		'branchcomment'					=> array(),
		'primary_address_street'		=> array("e6"),
		'primary_address_city'			=> array("e7",	REQUEST_ANY,	FORMAT_UCWORDS),
		'primary_address_state'			=> array("e9",	REQUEST_ANY,	FORMAT_UCWORDS),
		'primary_address_postalcode'	=> array("e8"),
		'address_country'				=> array("e18"),
		'alt_address_street'			=> array("e11"),
		'alt_address_city'				=> array("e12",	REQUEST_ANY,	FORMAT_UCWORDS),
		'alt_address_postalcode'		=> array("e13"),
		'alt_address_state'				=> array("e14",	REQUEST_ANY,	FORMAT_UCWORDS)
	);
	// get info
	if(get_request($fields_request,$currentinfo[0],$error,$cfg)) {
		$params = array(
			'module'			=> 'branch',
			'function'			=> 'create',
			'currentinfo'		=> $currentinfo,
			'organisationid'	=> $currentinfo[0]['organisationid']
		);	
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error occurred
		$params = array(
			'organisationid'	=> $currentinfo[0]['organisationid'],
			'currentinfo'		=> $currentinfo
		);
		xml_generator("branch","create",$error,$params,$cfg);	
	}	
} else {
	if($_SESSION['ts_classification'] == "3" 
		|| ($_SESSION['ts_classification'] == "2" && $_SESSION['ts_permission'] > "2")
		|| ($_SESSION['ts_classification'] == "1" && $_SESSION['ts_permission'] > "1")) {
		// 1047 - Missing Organisation ID
		// 1002 - Organisation ID must be a number
		$fields_request = array (
			'organisationid'	=> array("1047",	REQUEST_NUMBER,	FORMAT_NONE,	"1002")	
		);
		if(get_request($fields_request,$params,$error,$cfg)) {
			// create branch
			xml_generator("branch","create","",$params,$cfg);
		} else {
			// error
			xml_generator("branch","create",$error,$params,$cfg);
		}	
	} else {
		// e19 - you are not authorized to create a branch
		xml_generator("branch","error","e19",$params,$cfg);
	}
}
?>