<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Display branch profile
* @package TenderSystem
* @subpackage branch
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type
// 1053 - Missing Branch ID
// 1054 - Branch ID must be a number
$fields_request = array (
	'id'			=> array("1053",	REQUEST_NUMBER,	FORMAT_NONE,	"1054"),
	'changebranch'	=> array(),
	'deletebranch'	=> array()		
);
if(!get_request($fields_request,$action,$error,$cfg)) {
	// error
	xml_generator("branch","error",$error,$params,$cfg);	
} elseif($action['deletebranch']) {
	$update['status'] = "0";
	$params = array(
		'module'			=> 'branch',
		'function'			=> 'profile',
		'id'				=> $action['id'],
		'update'			=> $update
	);
	// send the message to app
	send_message($params,$cfg);
} elseif ($action['changebranch']) {
	// field request errors and type
	// e5 - Missing branch comment
	// e6 - Missing postal's address street
	// e7 - Missing postal's address city
	// e8 - Missing postal's postal code
	// e9 - Missing postal's state
	// e10 - Missing postal's country
	// e11 - Missing physical address street
	// e12 - Missing physical address city
	// e13 - Missing physical postal code
	// e14 - Missing physical state
	// e15 - Missing physical country
	// e16 - Missing branch name
	// 1017 - Phone Prefix must be a Number
	// 1018 - Phone Work not correctly formated
	// 1019 - Phone Fax not correctly formated
	// 1021 - Email not correctly formated
	// 1048 - Missing Phone Prefix"
	// 1049 - Missing Phone Work
	// 1050 - Missing Phone Fax
	// 1052 - Missing Email Address 
	$fields_request = array (
		'branchname'					=> array("e16",		REQUEST_ANY,	FORMAT_NONE,	"",		"name"),
		'phone_work'					=> array("1049",	REQUEST_PHONE,	FORMAT_PHONE,	"1018"),
		'phone_prefix'					=> array("1048",	REQUEST_NUMBER,	FORMAT_NONE,	"1017"),
		'phone_fax'						=> array("1050",	REQUEST_PHONE,	FORMAT_PHONE,	"1019"),
		'email'							=> array("1052",	REQUEST_EMAIL,	FORMAT_NONE,	"1021"),
		'comment'						=> array("",		REQUEST_ANY,	FORMAT_NONE,	"",		"branch_comment"),
		'primary_address_street'		=> array("e6"),
		'primary_address_city'			=> array("e7",	REQUEST_ANY,	FORMAT_UCWORDS),
		'primary_address_state'			=> array("e9"),
		'primary_address_postalcode'	=> array("e8"),
		'primary_address_country'		=> array("e10"),
		'alt_address_country'			=> array("e15"),
		'alt_address_street'			=> array("e11"),
		'alt_address_city'				=> array("e12",	REQUEST_ANY,	FORMAT_UCWORDS),
		'alt_address_postalcode'		=> array("e13"),
		'alt_address_state'				=> array("e14")
	);
	// get info;
	if(get_request($fields_request,$update,$error,$cfg)) {
		$params = array(
			'module'		=> 'branch',
			'function'		=> 'profile',
			'update'		=> $update,
			'id'			=> $action['id']
		);
	} else {
		$params = array(
			'module'		=> 'branch',
			'function'		=> 'profile',
			'id'			=> $action['id'],
			'error'			=> $error
		);	
	}
	// send the message to app
	send_message($params,$cfg);
} else {
	// set parameters
	$params = array(
		'module'		=> 'branch',
		'function'		=> 'profile',
		'id'				=> $action['id']
	);
	// send the message to app
	send_message($params,$cfg);
}
?>