<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/createprofile"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/createbranch"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'branch'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="branch"/>
					<input type="hidden" name="function" value="create"/>
					<input type="hidden" name="organisationid">
						<xsl:attribute name="value">
							<xsl:value-of select="organisationid"/>
						</xsl:attribute>
					</input>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/branchinfo"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchname" class="t2" value="{currentinfo/branchname}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'branchphone_prefix'"/>
									<xsl:with-param name="message" select="$lng/dialcode"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
									<xsl:with-param name="optionselected" select="currentinfo/branchphone_prefix"/>
									<xsl:with-param name="onchange" select="'change_other(address_country,this)'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchphone_work" class="t2" value="{currentinfo/branchphone_work}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchphone_fax" class="t2" value="{currentinfo/branchphone_fax}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchemail" class="t2" value="{currentinfo/branchemail}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/comment"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<textarea class="t2" name="branchcomment">
									<xsl:value-of select="currentinfo/branchcomment"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/country"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'address_country'"/>
									<xsl:with-param name="message" select="$lng/selectcountry"/>
									<xsl:with-param name="optionvalue" select="'name'"/>
									<xsl:with-param name="optioncontent" select="'name'"/>
									<xsl:with-param name="optionselected" select="currentinfo/address_country"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td colspan="3" class="h1 t1">
								<xsl:value-of select="$lng/primaryaddress"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_street" class="t2" value="{currentinfo/primary_address_street}" onchange="change_alt('address_street')"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_city" class="t2" value="{currentinfo/primary_address_city}" onchange="change_alt('address_city')"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_state" class="t2" value="{currentinfo/primary_address_state}" onchange="change_alt('address_state')"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_postalcode" class="t2" value="{currentinfo/primary_address_postalcode}" onchange="change_alt('address_postalcode')"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td colspan="3" class="h1 t1">
								<xsl:value-of select="$lng/alternativeaddress"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_street" class="t2" value="{currentinfo/alt_address_street}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_city" class="t2" value="{currentinfo/alt_address_city}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_state" class="t2" value="{currentinfo/alt_address_state}"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_postalcode" class="t2" value="{currentinfo/alt_address_postalcode}"/>
							</td>
						</tr>
						<tr>
							<td colspan="3"><br/></td>
						</tr>
						<tr>
							<td align="right" width="270" colspan="3">
								<input type="submit" name="createbranch" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/createbranch"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/creatingbranch"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/fillinfo"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function change_alt(name) {
			eval('document.report.alt_'+name+'.value = document.report.primary_'+name+'.value');
		}
		function change_other(first,second) {
			first.selectedIndex = second.selectedIndex;
		}
	</script>
</body>
</html> 

</xsl:template>

</xsl:stylesheet>
