<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/branchprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'branch'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="branch"/>
					<input type="hidden" name="function" value="profile"/>
					<input type="hidden" name="id" value="{branchinfo/branchid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="deleted='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/deletedbranch"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="created='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/created_branch"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/updated"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/branchinfo"/>:
								<xsl:value-of select="branchinfo/branchname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="branchname" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/branchname"/>
									</xsl:attribute>
									<xsl:attribute name="readonly"/>
									<xsl:attribute name="class">readonly t2</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<xsl:call-template name="countries">
										<xsl:with-param name="selectname" select="'phone_prefix'"/>
										<xsl:with-param name="message" select="$lng/dialcode"/>
										<xsl:with-param name="optionvalue" select="'dialcode'"/>
										<xsl:with-param name="optioncontent" select="'all'"/>
										<xsl:with-param name="optionselected" select="branchinfo/phone_prefix"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="editable='0'">
									<xsl:value-of select="branchinfo/phone_prefix"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left"  class="t2">
								<input type="text" name="phone_work" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/phone_work"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td align="right"  class="t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:value-of select="branchinfo/phone_prefix"/>
										<xsl:number value="branchinfo/phone_work" format="1"/>
									</xsl:attribute>
									<img src="./theme/{$theme}/icon/call.gif" border="0">
										<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
									</img>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="phone_fax" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/phone_fax"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td align="right"  class="t1">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:value-of select="branchinfo/phone_prefix"/>
										<xsl:number value="branchinfo/phone_fax" format="1"/>
									</xsl:attribute>
									<img src="./theme/{$theme}/icon/call.gif" border="0">
										<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
									</img>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="email" class="t2" size="30">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/email"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td align="right"  class="t1">
								<a href="mailto:{branchinfo/email}">
									<img src="./theme/{$theme}/icon/mail_replay.gif" border="0">
										<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
									</img>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/comment"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<textarea class="t2" name="comment">
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
									<xsl:value-of select="branchinfo/comment"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="3" align="left" class="h1 t1"><xsl:value-of select="$lng/primaryaddress"/></td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_street" class="t2" size="30">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/primary_address_street"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_city" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/primary_address_city"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_state" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/primary_address_state"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="primary_address_postalcode" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/primary_address_postalcode"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/country"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<xsl:call-template name="countries">
										<xsl:with-param name="selectname" select="'primary_address_country'"/>
										<xsl:with-param name="message" select="$lng/selectcountry"/>
										<xsl:with-param name="optionvalue" select="'name'"/>
										<xsl:with-param name="optioncontent" select="'name'"/>
										<xsl:with-param name="optionselected" select="branchinfo/primary_address_country"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="editable='0'">
									<xsl:value-of select="branchinfo/primary_address_country"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="3" align="left" class="h1 t1"><xsl:value-of select="$lng/alternativeaddress"/></td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/street"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_street" class="t2" size="30">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/alt_address_street"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/city"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_city" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/alt_address_city"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_state" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/alt_address_state"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/postalcode"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<input type="text" name="alt_address_postalcode" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="branchinfo/alt_address_postalcode"/>
									</xsl:attribute>
									<xsl:if test="editable='0'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">readonly t2</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/country"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:if test="editable='1'">
									<xsl:call-template name="countries">
										<xsl:with-param name="selectname" select="'alt_address_country'"/>
										<xsl:with-param name="message" select="$lng/selectcountry"/>
										<xsl:with-param name="optionvalue" select="'name'"/>
										<xsl:with-param name="optioncontent" select="'name'"/>
										<xsl:with-param name="optionselected" select="branchinfo/alt_address_country"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="editable='0'">
									<xsl:value-of select="branchinfo/alt_address_country"/>
								</xsl:if>
							</td>
						</tr>
						<tr><td><br/></td></tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="branchinfo/created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="branchinfo/created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',branchinfo/creatorid)"/>
									</xsl:attribute>
									<xsl:value-of select="branchinfo/creatorname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="branchinfo/creatorsurname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="branchinfo/status='1'">
										<xsl:value-of select="$lng/active"/>
									</xsl:when>
									<xsl:when test="branchinfo/status='0'">
										<xsl:attribute name="class">e</xsl:attribute>
										<xsl:value-of select="$lng/deleted"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:if test="editable='1'">
							<tr>
								<td align="center" width="270" colspan="4">
									<input type="submit" name="changebranch" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/changebranch"/>
										</xsl:attribute>
									</input>
									<xsl:if test="branchinfo/branchid!=user/branchid">
										<input type="checkbox" name="deletebranch" class="t2" onchange="alertremove()"/>
										<xsl:value-of select="$lng/delete"/>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/organisationinfo"/>:
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',branchinfo/organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="branchinfo/organisationname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',branchinfo/organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="branchinfo/organisationname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/transactionfee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><xsl:value-of select="branchinfo/transaction_fee"/><xsl:value-of select="/localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/userfee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><xsl:value-of select="branchinfo/user_fee"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/messagefee"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="localprecurrency"/><xsl:value-of select="branchinfo/sms_fee"/><xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<!-- Organisation Status -->
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="branchinfo/orgstatus='1'">
										<xsl:value-of select="$lng/active"/>
									</xsl:when>
									<xsl:when test="branchinfo/orgstatus='0'">
										<xsl:attribute name="class">e</xsl:attribute>
										<xsl:value-of select="$lng/deleted"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/otherinfo"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/users"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=search&amp;branchid=',branchinfo/branchid)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/editbranchinfo"/>
				</div>
				<div id="right_content">
					<xsl:if test="editable='1'">
						<xsl:value-of select="$lng/freetoedit"/>
					</xsl:if>
					<xsl:if test="editable='0'">
						<xsl:value-of select="$lng/notfreetoedit"/>
					</xsl:if>
				</div>
			</div>
		</div>
	</div>
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deletebranch.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdelete"/>")) {
					document.report.deletebranch.checked = false;
				}
			}
		}
		<xsl:if test="created='1' or deleted='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
