<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create category
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'	=> array(),
	'upload'	=> array()
);
get_request($fields_request,$action,$error,$cfg);
// set the variables
if($action['upload']) {
	// field request errors and type 
	$fields_request = array (
		'category'			=> array(),
		'icategory'			=> array(),
		'category_type'		=> array(),
		'category_sub'		=> array(),
		'icategory_sub'		=> array()
	);
	get_request($fields_request,$info,$error,$cfg);
	// go through each category
	$params = array(
		'module'		=> 'category',
		'function'		=> 'create',
		'categorytype'	=> sanitise($_POST['category_type'])
	);
	foreach($info['category'] as $key => $value) {
		// check if must be ignored
		if($info['icategory'][$key] != "on" && $value)	{
			$tmp_category['name'] = $value;
			// go through each sub category
			foreach($info['category_sub'][$key] as $key_c => $value_c) {
				// check if must be ignored
				if($info['icategory_sub'][$key][$key_c] != "on" && $value_c) {
					$tmp_category['category_sub'][] = $value_c;
				}
			}
			$params['category'][] = $tmp_category;
			unset($tmp_category);
		}
	}
	// send the message to app
	send_message($params,$cfg);
} elseif ($action['action']) {
	// set the variables
	$file = $_FILES['file'];
	// determine if file must be uploaded
	if ($file['name']) {
		// upload the file
		$upload_dest = upload_file($file,"category",$cfg);
		// send to the app
		if (is_string($upload_dest)) {
			// set file information
			$extension = substr(strrchr($upload_dest, "."), 1);
			if(!in_array($extension,array("xls"))) {
				// e1 - Unauthorised filetype, must be xsl file
				xml_generator("category","create","e1",$params,$cfg);
			} else {
				// read the excel spreadsheet
				$spreadsheet = read_excel($upload_dest,$cfg);
				// set what to display form
				$params['show'] = "1";
				// set category counter
				$category_counter = -1;
				// loop through the spreedsheet values
				foreach($spreadsheet as $row => $values) {
					foreach($values as $col => $value) {
						if (!trim($value)) {
							continue;
						}
						if($col == "0") {
							$params['category'][++$category_counter]['categoryname'] = $value;
							$category_sub_counter = -1;
						} else {
							// set category_sub
							$params['category'][$category_counter]['category_sub'][++$category_sub_counter]['category_subname'] = $value;
						}
					}
				}
				// display message
				xml_generator("category","show_category_upload","",$params,$cfg);
			}
		} else {
			// display error
			xml_generator("category","create",$upload_dest['error'],$params,$cfg);
		}
	} else {
		// field request errors and type 
		// e2 - Missing category name
		$fields_request = array (
			'category_name'		=> array("e2",	REQUEST_ANY,	FORMAT_UCWORDS),
			'category_type'		=> array(),
			'genericapp'		=> array()
		);
		get_request($fields_request,$info,$error,$cfg);
		if($info['genericapp']) {
			$params = array(
				'module'		=> 'category',
				'function'		=> 'create',
				'genericapp'	=> $info['genericapp']
			);
			// send the message to app
			send_message($params,$cfg);
		} elseif($info['category_name']) {
			// parameters to send to the application server
			$category[]['name'] = $info['category_name'];
			$params = array(
				'module'		=> 'category',
				'function'		=> 'create',
				'category'		=> $category,
				'categorytype'	=> $info['category_type']
			);
			// send the message to app
			send_message($params,$cfg);
		} else {
			// display error
	 		xml_generator("category","error",$error,$params,$cfg);
		}
	}
} else {
	$params = array(
		'module'	=> 'category',
		'function'	=> 'create'
	);
	// display message
	send_message($params,$cfg);
}
?>