<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create brand
* @package TenderSystem
* @subpackage category
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'	=> array(),
	'upload'	=> array()		
);
get_request($fields_request,$action,$error,$cfg);
if($action['upload']) {
	$fields_request = array (
		'brand'	=> array(),
		'allbrand'	=> array()		
	);
	get_request($fields_request,$info,$error,$cfg);
	$params = array(
		'module'	=> 'category',
		'function'	=> 'create_brand'
	);
	foreach($info['brand'] as $key => $value) {
		if($info['allbrand'][$key] != "on")	{
			$params['brandnames'][] = $value;
		}
	}
	// send the message to app
	send_message($params,$cfg);
} elseif ($action['action']) {
	// set the variables
	$file = $_FILES['file'];
	// determine if file must be uploaded
	if ($file['name']) {
		// upload the file
		$upload_dest = upload_file($file,"category",$cfg);
		// send to the app
		if (is_string($upload_dest)) {
			// set file information
			$extension = substr(strrchr($upload_dest, "."), 1);
			if(!in_array($extension,array("xls"))) {
				// Can't upload this filetype
				$error[] = "e1";
				// display error
				 xml_generator("category","create_brand",$error,$params,$cfg);
			} else {
				// determine spreadsheet
				if($extension == "xls") {
					// read the excel spreadsheet
					$spreadsheet = read_excel($upload_dest,$cfg);
				}
				// set what to display form
				$params['show'] = "1";
				// set category counter
				$brand_counter = -1;
				// loop through the spreedsheet values
				foreach($spreadsheet as $row => $values) {
					foreach($values as $col => $value) {
						if (!trim($value)) {
							continue;
						}
						// replace [space] with _
						$brand = str_replace(" ","_",$value);
						$params['brand'][++$brand_counter]['brandname'] = $brand;
						$params['brand'][$brand_counter]['brandnumber']  = $brand_counter;
					}
				}
				// display message
				xml_generator("category","show_brand_upload","",$params,$cfg);
			}
		} else {
			// display error
			xml_generator("category","create_brand",$upload_dest['error'],$params,$cfg);
		}
	} else {
		$fields_request = array (
			'brandname'	=> array("e3",	REQUEST_ANY,	FORMAT_UCWORDS)	
		);
		if(get_request($fields_request,$info,$error,$cfg)) {
			// parameters to send to the application server
			$brandnames[] = $info['brandname'];
			$params = array(
				'module'		=> 'category',
				'function'		=> 'create_brand',
				'brandnames'	=> $brandnames
			);
			// send the message to app
			send_message($params,$cfg);	
		} else {
			// display error
		 	xml_generator("category","error",$error,$params,$cfg);
		}
	}
} else {
	// display message
	xml_generator("category","create_brand","",$params,$cfg);
}
?>