<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="category_script">
	<xsl:param name="functionname" select="'update_category'"/>
	<xsl:param name="selectcategory" select="'category'"/>
	<xsl:param name="selectcategory_sub" select="'category_sub'"/>
	<xsl:param name="zerooption" select="'yes'"/>
	function <xsl:value-of select="$functionname"/>() {	
	<xsl:if test="/response/category/categoryid">
		var categoryIndex = document.report.<xsl:value-of select="$selectcategory"/>.selectedIndex;
		var categoryValue = document.report.<xsl:value-of select="$selectcategory"/>.value;
	<xsl:if test="/response/subcategory/categoryid">
		var subcategorySelect = document.report.<xsl:value-of select="$selectcategory_sub"/>;
		var subcategoryOptions = subcategorySelect.options;
		var counter = 0;
		subcategorySelect.length = 0;
		<xsl:if test="$zerooption='yes' or $zerooption='1'">
		subcategoryOptions[counter++] = new Option("<xsl:value-of select="$lng/selectsubcategory"/>","");
		</xsl:if>
	<xsl:for-each select="/response/subcategory">
		if (categoryValue == "<xsl:value-of select="./categoryid"/>") {
			subcategoryOptions[counter++] = new Option("<xsl:value-of select="subcategoryname"/>","<xsl:value-of select="subcategoryid"/>");
		}
	</xsl:for-each>
		<xsl:if test="$zerooption='yes' or $zerooption='1'">
		if(counter == 1) {
			subcategorySelect.disabled = 1;
		} else {
			subcategorySelect.disabled = 0;
		}
		</xsl:if>
		<xsl:if test="$zerooption!='yes' and $zerooption!='1'">
		if(counter == 0) {
			subcategorySelect.disabled = 1;
		} else {
			subcategorySelect.disabled = 0;
		}
		</xsl:if>
	</xsl:if>
	</xsl:if>
	}
</xsl:template>

<xsl:template name="brandupdate_script">
	function brandupdate(first,second) {
		first.value = second.value;
	}
</xsl:template>

<xsl:template name="changebrand_script">
	<xsl:param name="functionname" select="'changebrand'"/>
	<xsl:param name="brandfield" select="'brandselect'"/>
	<xsl:param name="categoryfield" select="'category'"/>
	function <xsl:value-of select="$functionname"/>() {
		var value = document.report.<xsl:value-of select="$categoryfield"/>.value;
		var brandSelect = document.report.<xsl:value-of select="$brandfield"/>;
		var brandOptions = brandSelect.options;
		var counter = 0;
		brandOptions.length = 0;
		brandOptions[counter++] = new Option("<xsl:value-of select="$lng/selectbrand"/>","");
	<xsl:for-each select="/response/brand">
		if (value == "<xsl:value-of select="category"/>" | value =="") {
			brandOptions[counter++] =  new Option("<xsl:value-of select="brandname"/>","<xsl:value-of select="brandname"/>");
		}
	</xsl:for-each>
	}
</xsl:template>

<xsl:template name="category_field">
	<xsl:param name="onchange" select="'changesub();changebrand();'"/>
	<xsl:param name="fieldname" select="'category'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="selected" select="procure/category"/>
	<xsl:param name="category" select="category_hidden"/>
	<xsl:param name="empty_td" select="'no'"/>
	<xsl:choose>
		<xsl:when test="/response/category/categoryid">
			<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
				<td class="t1"><xsl:value-of select="$lng/category"/></td>
				<td>
					<xsl:call-template name="category_select">
						<xsl:with-param name="onchange" select="$onchange"/>
						<xsl:with-param name="fieldname" select="$fieldname"/>
						<xsl:with-param name="fieldid" select="$fieldid"/>
						<xsl:with-param name="zerooption" select="$zerooption"/>
						<xsl:with-param name="selected" select="$selected"/>
					</xsl:call-template>
				</td>
			</tr>
		</xsl:when>
		<xsl:when test="$category">
			<input type="hidden" name="{$fieldname}" value="{$category}"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>
	
<xsl:template name="category_select">
	<xsl:param name="onchange" select="'changesub();changebrand();'"/>
	<xsl:param name="fieldname" select="'category'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="selected" select="procure/category"/>
	<select name="{$fieldname}" onChange="{$onchange}" class="t2">
	<xsl:if test="$fieldid!=''">
		<xsl:attribute name="id"><xsl:value-of select="$fieldid"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="$zerooption='yes' or $zerooption='1'">
		<option value="">
			<xsl:value-of select="$lng/selectcategory"/>
		</option>
	</xsl:if>
	<xsl:for-each select="/response/category">
		<option value="{categoryid}">
			<xsl:if test="categoryid=$selected">
				<xsl:attribute name="selected">selected</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="categoryname"/>
		</option>
	</xsl:for-each>
	</select>
</xsl:template>

<xsl:template name="category_sub_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'subcat'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="selected" select="procure/category_sub"/>
	<xsl:param name="category_sub" select="category_sub_hidden"/>
	<xsl:param name="empty_td" select="'no'"/>
	<xsl:choose>
		<xsl:when test="$category_sub">
			<input type="hidden" name="{$fieldname}" value="{$category_sub}"/>
		</xsl:when>
		<xsl:when test="/response/category_sub/subcategoryid">
			<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td><br/></td>
				</xsl:if>
				<td class="t1"><xsl:value-of select="$lng/subcat"/></td>
				<td class="t2">
					<select name="{$fieldname}" class="t2" onchange="{$onchange}">
						<xsl:if test="$fieldid!=''">
							<xsl:attribute name="id"><xsl:value-of select="$fieldid"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="$zerooption='yes' or $zerooption='1'">
							<option><xsl:value-of select="$lng/selectsubcategory"/></option>
						</xsl:if>
						<xsl:for-each select="/response/category_sub">
							<option value="{subcategoryid}">
							<xsl:if test="subcategoryid=$selected">
								<xsl:attribute name="selected"/>						
							</xsl:if>
								<xsl:value-of select="subcategoryname"/>
							</option>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</xsl:when>
		<xsl:otherwise>
			<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td><br/></td>
				</xsl:if>
				<td class="t1"><xsl:value-of select="$lng/subcat"/></td>
				<td class="t2">
					<select name="{$fieldname}" class="t2" onchange="{$onchange}">
						<xsl:if test="$fieldid!=''">
							<xsl:attribute name="id"><xsl:value-of select="$fieldid"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="$zerooption='yes' or $zerooption='1'">
							<option><xsl:value-of select="$lng/selectsubcategory"/></option>
						</xsl:if>
					</select>
				</td>
			</tr>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="brand_field">
	<xsl:param name="onchange" select="'brandupdate(brand,this)'"/>
	<xsl:param name="selectname" select="'brandselect'"/>
	<xsl:param name="fieldname" select="'brand'"/>
	<xsl:param name="fieldid" select="''"/>
	<xsl:param name="inputid" select="''"/>
	<xsl:param name="zerooption" select="'yes'"/>
	<xsl:param name="brand" select="procure/brand"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<xsl:if test="$empty_td='1' or empty_td='yes'">
			<td ><br/></td>
		</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/brand"/></td>
		<td class="t2">
		<xsl:if test="brand">
			<select name="{$selectname}" class="t2" onchange="{$onchange}">
			<xsl:if test="$fieldid!=''">
				<xsl:attribute name="id"><xsl:value-of select="$fieldid"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$zerooption='yes' or $zerooption='1'">
				<option value="">
					<xsl:value-of select="$lng/selectbrand"/>
				</option>
			</xsl:if>
			<xsl:for-each select="brand">
				<option value="{brandname}">
					<xsl:value-of select="brandname"/>
				</option>
			</xsl:for-each>
			</select>
		</xsl:if>
			<input type="text" name="{$fieldname}" size="10" class="t2" value="{$brand}">
				<xsl:if test="$inputid!=''">
					<xsl:attribute name="id"><xsl:value-of select="$inputid"/></xsl:attribute>
				</xsl:if>
			</input>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>