<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/createcategory"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'category'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="category"/>
					<input type="hidden" name="function" value="create"/>
					<input type="hidden" name="categoryid" value="{categoryid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
					<xsl:if test="deleted='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/deletedcategory"/>
							</td>
						</tr>
					</xsl:if>
			<xsl:if test="created='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/createdcategory"/>
							</td>
						</tr>
				<xsl:if test="category">
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/createdcategories"/>
							</td>
						</tr>
					<xsl:for-each select="category">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="brand">
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/createdbrands"/>
							</td>
						</tr>
					<xsl:for-each select="brand">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="category_sub">
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/createdsubcategories"/>
							</td>
						</tr>
					<xsl:for-each select="category_sub">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
			</xsl:if>
				<xsl:if test="exist_category">
						<tr>
							<td class="h e">
								<xsl:value-of select="$lng/existcategory"/>
							</td>
						</tr>
					<xsl:for-each select="exist_category">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="exist_category_sub">
						<tr>
							<td class="h e">
								<xsl:value-of select="$lng/existcategorysub"/>
							</td>
						</tr>
					<xsl:for-each select="exist_category_sub">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td class="t2">
								<input type="text" name="category_name" size="12" value="" maxlenght="32" class="t2"/>
							</td>
							<td colspan="2" class="t2" align="left">
								<select name="category_type" class="t2">
									<option value="1"><xsl:value-of select="$lng/normaltype"/></option>
							<xsl:if test="category_classification">
								<xsl:for-each select="category_classification">
									<option value="{classification}"><xsl:value-of select="name"/></option>
								</xsl:for-each>
							</xsl:if>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/upload"/>
							</td>
							<td colspan="3" class="t2">
								<input type="file" name="file" size="15" class="t2"/>
							</td>
						</tr>
					<xsl:if test="genericapp">
						<tr>
							<td class="t1" valign="top">
								<xsl:value-of select="$lng/generic"/><br/>(<xsl:value-of select="$lng/appside"/>)
							</td>
							<td class="t2">
								<xsl:for-each select="genericapp">
									<input type="radio" name="genericapp">
										<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
									</input>
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td class="t1"><br/></td>
							<td colspan="3" class="t1">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<xsl:if test="show!='1'">
					<div id="right_header">
						<xsl:value-of select="$lng/instheader"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/inst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</div>
				</xsl:if>
				<xsl:if test="show='1'">
					<div id="right_header">
						<xsl:value-of select="$lng/instheader"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/loadinst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</div>
				</xsl:if>
				<div id="right_header">
					<xsl:value-of select="$lng/downloadheader"/>
				</div>
				<div id="right_content">
					<a href="./modules/category/language/{$language}/spreadsheet/category_upload.xls">
						<img border="0" src="./theme/{$theme}/icon/xls.gif" alt=""/>
						<xsl:value-of select="$lng/download"/>
					</a>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	
		<xsl:if test="created='1' or deleted='1' or reactived='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
