<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/createbrand"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'category'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report" id="sitediv">
					<input type="hidden" name="module" value="category"/>
					<input type="hidden" name="function" value="create_brand"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
				<xsl:if test="created='1'">
					<xsl:if test="brand">
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/createdbrands"/>
							</td>
						</tr>
						<xsl:for-each select="brand">
							<tr>
								<td class="t1">
									<xsl:value-of select="name"/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
				</xsl:if>
				<xsl:if test="exist_brand">
					<tr>
						<td class="h e">
							<xsl:value-of select="$lng/existbrand"/>
						</td>
					</tr>
					<xsl:for-each select="exist_brand">
						<tr>
							<td class="t2">
								<xsl:value-of select="name"/>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/name"/>
							</td>
							<td colspan="3" class="t2">
								<input type="text" name="brandname" size="12" value="" maxlenght="32" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/upload"/>
							</td>
							<td colspan="3" class="t2">
								<input type="file" name="file" size="15" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1"><br/></td>
							<td colspan="3" class="t1">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/instheader"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/instb">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
				<div id="right_header">
					<xsl:value-of select="$lng/downloadheader"/>
				</div>
				<div id="right_content">
					<a href="./modules/category/language/{$language}/spreadsheet/brand_upload.xls">
						<img border="0" src="./theme/{$theme}/icon/xls.gif" alt=""/>
						<xsl:value-of select="$lng/download"/>
					</a>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	
		<xsl:if test="created='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
