<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data" action="left.php?module=useradmin&amp;function=search" method="post" name="report">
						<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td class="t1">
									<a href="main.php?module=category&amp;function=create" target="main"><xsl:value-of select="$lng/createcategory"/></a>
								</td>
							</tr>
							<xsl:if test="category/categoryid">
								<tr>
									<td class="t2">
										<select name="category" class="t1" onchange="update(); updatebrand()">
											<option value="0"><xsl:value-of select="$lng/selectcategory"/></option>
											<xsl:variable name="categorymatchid" select="categoryid"/>
											<xsl:for-each select="category">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="./categoryid"/></xsl:attribute>
													<xsl:if test="./categoryid=$categorymatchid">
														<xsl:attribute name="selected">selected</xsl:attribute> 
													</xsl:if>
													<xsl:value-of select="categoryname"/>
												</option>		
											</xsl:for-each> 
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/categoryadmin"/>
										<ul>
											<li>
												<a href="#" onclick="remove('category','delete')"><xsl:value-of select="$lng/delete"/></a>
											</li>
										</ul>
										<ul>
											<li>
												<a href="#" onclick="link('category','show_brand')"><xsl:value-of select="$lng/brands"/></a>
											</li>
										</ul>
									</td>
								</tr>
								<tr>
									<td class="t1">
										<a href="#" onclick="create('subcategory')"><xsl:value-of select="$lng/createsubcategory"/></a>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="subcategory/categoryid">
								<tr>
									<td class="t2">
										<select name="subcategory" class="t1">
										</select>
									</td>
								</tr>
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/subcategoryadmin"/>
										<ul>
											<li>
												<a href="#" onclick="remove('category','delete_sub')"><xsl:value-of select="$lng/delete"/></a>
											</li>
										</ul>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td class="t1">
									<a href="main.php?module=category&amp;function=create_brand" target="main"><xsl:value-of select="$lng/createbrand"/></a>
								</td>
							</tr>
							<xsl:if test="brand/brandid">
								<tr>
									<td class="t2">
										<select name="brand" class="t1">
										</select>
									</td>
								</tr>
								<!--<tr>
									<td class="t2">
										<select name="brand" class="t1" onchange="update()">
										<option value="0"><xsl:value-of select="$lng/selectbrand"/></option>
										<xsl:variable name="brandmatchid" select="brandid"/>
										<xsl:for-each select="brand">
												<option>
													<xsl:attribute name="value"><xsl:value-of select="./brandid"/></xsl:attribute>
													<xsl:if test="./brandid=$brandmatchid">
														<xsl:attribute name="selected">selected</xsl:attribute> 
													</xsl:if>
													<xsl:value-of select="brandname"/>
												</option>		
										</xsl:for-each> 
										</select>
									</td>
								</tr>-->
								<tr>
									<td class="t2">
										<xsl:value-of select="$lng/brandadmin"/>
										<ul>
											<li>
												<a href="#" onclick="remove('category','delete_brand')"><xsl:value-of select="$lng/delete"/></a>
											</li>
										</ul>
									</td>
								</tr>
							</xsl:if>
						</table>
					</form>
				<script language="javascript">
					function remove(myModule,myFunction) {
				<xsl:if test="category/categoryid">
						if(myFunction == "delete") {
							var select = "category";
						}
				</xsl:if>
				<xsl:if test="subcategory/categoryid">
						if(myFunction == "delete_sub") {
							var select = "subcategory";
						}
				</xsl:if>
				<xsl:if test="brand/brandid">
						if(myFunction == "delete_brand") {
							var select = "brand";
						}
				</xsl:if>
						var myIndex = eval('document.report.'+select+'.selectedIndex');
						var name = eval('document.report.'+select+'.options[myIndex].text');
						var id = eval('document.report.'+select+'.value');
						if (myIndex) {
							if(confirm("<xsl:value-of select="$lng/delete"/> "+name)) {
								parent.main.location.href = "main.php?module="+myModule+"&amp;function="+myFunction+"&amp;categoryid="+id+"&amp;subcategoryid="+id+"&amp;brandid="+id;
							}
						} else {
				<xsl:if test="category/categoryid">
							if(select == "category") {
								alert("<xsl:value-of select="$lng/selectcategory"/>");
							}
				</xsl:if>
				<xsl:if test="subcategory/categoryid">
							if(select == "subcategory") {
								alert("<xsl:value-of select="$lng/selectsubcategory"/>");
							}
				</xsl:if>
				<xsl:if test="brand/brandid">
							if(select == "brand") {
								alert("<xsl:value-of select="$lng/selectbrand"/>");
							}
				</xsl:if> 
							
						}
					}
			
					function create(Type) {	
				<xsl:if test="category/categoryid">
						var categoryIndex = document.report.category.selectedIndex;
						var categoryid = document.report.category.value;
						if (categoryIndex) {
							parent.main.location.href = "main.php?module=category&amp;function=create_sub&amp;categoryid="+categoryid;
						} else {
							alert("<xsl:value-of select="$lng/selectcategory"/>");
						}
				</xsl:if>
					}
				
					function update() {	
				<xsl:if test="category/categoryid">
						var categoryIndex = document.report.category.selectedIndex;
						var categoryValue = document.report.category.value;
					<xsl:if test="subcategory/categoryid">
						var subcategorySelect = document.report.subcategory;
						var subcategoryOptions = subcategorySelect.options;
						var counter = 0;
						subcategorySelect.length = 0;
						subcategoryOptions[counter++] = new Option("<xsl:value-of select="$lng/selectsubcategory"/>","");
						<xsl:for-each select="subcategory">
						if (categoryValue == "<xsl:value-of select="./categoryid"/>" || categoryValue == "0") {
							subcategoryOptions[counter++] = new Option("<xsl:value-of select="subcategoryname"/>","<xsl:value-of select="subcategoryid"/>");
						}
						</xsl:for-each>
						if(counter == 1) {
							subcategorySelect.disabled = 1;
						} else {
							subcategorySelect.disabled = 0;
						}
					</xsl:if>
					


				</xsl:if>
					}
					function updatebrand() {
					<xsl:if test="category/categoryid">
						var categoryIndex = document.report.category.selectedIndex;
						var categoryValue = document.report.category.value;					
						<xsl:if test="brand/brandid">
							var brandSelect = document.report.brand;
							var brandOptions = brandSelect.options;
							var counter = 0;
							brandSelect.length = 0;
							brandOptions[counter++] = new Option("<xsl:value-of select="$lng/selectbrand"/>","");
							<xsl:for-each select="brand">
							if (categoryValue == "<xsl:value-of select="./category"/>" || categoryValue == "0") {
								brandOptions[counter++] = new Option("<xsl:value-of select="brandname"/>","<xsl:value-of select="brandid"/>");
							}
							</xsl:for-each>
							if(counter == 1) {
								brandSelect.disabled = 1;
							} else {
								brandSelect.disabled = 0;
							}
						</xsl:if>	
					</xsl:if>	
					}
					function link(myModule,myFunction) {
					<xsl:if test="category/categoryid">
						var categoryIndex = document.report.category.selectedIndex;
						var categoryid = document.report.category.value;
						if (categoryIndex) {
							parent.main.location.href = "main.php?module="+myModule+"&amp;function="+myFunction+"&amp;categoryid="+categoryid;
						} else {
							alert("<xsl:value-of select="$lng/selectcategory"/>");
						}
					</xsl:if>
					}
					
					update();
					updatebrand();
				</script>
			</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>