<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/categorybrand"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'category'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="category"/>
					<input type="hidden" name="function" value="show_brand"/>
					<input type="hidden" name="categoryid" value="{categoryid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td colspan="8" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/updated"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="6" class="h t1">
									<xsl:value-of select="$lng/brandnames"/>
							</td>
							<td colspan="2" class="ha t1">
								<input type="checkbox" class="t2" id="site" name="checkall" onchange="CheckAll(this)"/>
									<xsl:value-of select="$lng/checkall"/>
							</td>
						</tr>
							<xsl:for-each select="brand[position() mod 4 = 1]">
								<tr>
									<xsl:for-each select=".|following-sibling::brand[position() &lt; 4]">
										<xsl:variable name="currentid" select="brandid"/>
										<xsl:choose>
											<xsl:when test="position()=1">
												<td class="h2b t1">
													<xsl:value-of select="brandname"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td class="h2c t1">
													<xsl:value-of select="brandname"/>
												</td>
											</xsl:otherwise>
										</xsl:choose>
										<td class="h2c t2" align="left">
											<input type="checkbox" class="t2" name="brandselect[{brandid}]">
												<xsl:for-each select="../selectedbrand">
													<xsl:if test="brandid=$currentid">
														<xsl:attribute name="checked">checked</xsl:attribute>
													</xsl:if>
												</xsl:for-each> 
											</input>
										</td>
									</xsl:for-each>
								</tr>
							</xsl:for-each>
							<tr>
								<td class="t1" colspan="8" align="right">
									<input type="submit" name="change" class="t2">
										<xsl:attribute name="value"><xsl:value-of select="$lng/changebrands"/></xsl:attribute>
									</input>
									<xsl:value-of select="' '"/>
									<input type="submit" name="reset" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/reset"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/categorybrand"/>
				</div>
				<div id="right_content">
					<xsl:value-of select="$lng/categorybrandinst"/>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<xsl:if test="updated='1'">
		<script type="text/javascript">
			parent.left.location.reload();
		</script>
	</xsl:if>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
