<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/createcategory"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'category'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="category"/>
					<input type="hidden" name="function" value="create"/>
					<input type="hidden" name="categoryid" value="{categoryid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
					<xsl:if test="not(category)">
						<tr>
							<td colspan="2" class="t1">
								<xsl:value-of select="$lng/nothingtoupload"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="category">
						<tr>
							<td colspan="2" class="h t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td class="ha t1" align="left">
								<input type="checkbox" class="t2" id="site" name="allall" onchange="CheckAll(this)"/>
								<xsl:value-of select="$lng/iall"/>
							</td>
						</tr>
						<xsl:for-each select="category">
							<tr>
								<td colspan="2" class="h1b t1">
									<input type="text" size="20" maxlenght="32" class="t2" name="category[{categoryname}]" value="{categoryname}"/>
								</td>
								<td class="h1c t1" align="left">
									<input type="checkbox" class="t2" onchange="CheckAll(this)" id="{categoryname}" name="icategory[{categorynumber}]"/>
									<xsl:value-of select="$lng/iallcategory"/>
								</td>
							</tr>
							<tr>
							<td colspan="3" class="h2b">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
									<xsl:attribute name="id"><xsl:value-of select="categoryname"/>div</xsl:attribute>
							 		<xsl:for-each select="category_sub">
										<tr>
											<td><br/></td>
											<td class="t1">
												<input type="text" size="20" maxlenght="32" class="t2" value="{category_subname}">
													<xsl:attribute name="name">category_sub[<xsl:value-of select="../categoryname"/>][<xsl:value-of select="category_subname"/>]</xsl:attribute>												
												</input>
											</td>
											<td align="left">
												<input type="checkbox" class="t2" name="icategory_sub[{categoryname}][{category_subname}]">
													<xsl:attribute name="name">icategory_sub[<xsl:value-of select="../categoryname"/>][<xsl:value-of select="category_subname"/>]</xsl:attribute>												
												</input>
											</td>
										</tr>
									</xsl:for-each> 
								</table>
							</td></tr>
						</xsl:for-each>
						<tr>
							<td colspan="4" class="t1" align="right">
								<input type="submit" name="cancel" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/cancel"/>
									</xsl:attribute>
								</input>
								<input type="submit" class="t2" name="upload">
									<xsl:attribute name="value"><xsl:value-of select="$lng/upload"/></xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<xsl:if test="show!='1'">
					<div id="right_header">
						<xsl:value-of select="$lng/instheader"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/inst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</div>
				</xsl:if>
				<xsl:if test="show='1'">
					<div id="right_header">
						<xsl:value-of select="$lng/instheader"/>
					</div>
					<div id="right_content">
						<xsl:for-each select="$lng/loadinst">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</div>
				</xsl:if>
				<div id="right_header">
					<xsl:value-of select="$lng/downloadheader"/>
				</div>
				<div id="right_content">
					<a href="./modules/category/language/{$language}/spreadsheet/category_upload.xls">
						<img border="0" src="./theme/{$theme}/icon/xls.gif" alt=""/>
						<xsl:value-of select="$lng/download"/>
					</a>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	
		<xsl:if test="created='1' or deleted='1' or reactived='1'">
			parent.left.location.reload();
		</xsl:if>
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
