<?php
/// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Attachment
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
// e11 - Not a valid language
// e12 - Missing authentication string
// e13 - Missing attachment id
// e14 - Attachment id must be a number
// 1000 - User ID must be a number
// 1038 - Missing User ID
// 1037 - Missing Language
$fields_request = array (
	'user_id'			=> array("1038",	REQUEST_NUMBER,	FORMAT_NONE,"1000"),
	'language'			=> array("1037",	REQUEST_LANG,	FORMAT_NONE,	"e11"),
	'authentication'	=> array("e12"),
	'id'				=> array("e13",	REQUEST_NUMBER,	FORMAT_NONE,	"e14")
);
if(get_request($fields_request,$info,$error,$cfg)) {
	// set paramaters
	$params = array(
		'module'			=> 'generic',
		'function'			=> 'attachment',
		'user_id'			=> $info['user_id'],
		'language'  		=> $info['language'],
		'id'  				=> $info['id'],
		'authentication'	=> $info['authentication']
	);
	// set that only info required and should not be displayed
	$cfg['api_request'] = TRUE;
	// send the message to app
	$xml = send_message($params,$cfg);
	$filetype = event_parser("<filetype>","</filetype>",$xml);
	$filename = event_parser("<filename>","</filename>",$xml);
	$filecontent = event_parser("<filecontent>","</filecontent>",$xml);
	// decode
	$content = base64_decode($filecontent);
	$filesize = strlen($content);
	// determine if request was successfull
	if($filetype == "text/html") {
		echo $content;
	} elseif ($filesize && $filetype && $filename) {
		// set the header and display
		$header_name = "Content-Disposition: attachment; filename=\"".$filename."\"";
		header($header_name);
		header("Content-Type: application/octet-stream");
		header("Content-Length: ".$filesize);
		header("Pragma: no-cache");
		header("Expires: 0");
		echo $content;
	} else {
		// display xml
		display_response($xml,$cfg);
	}
} else {
	// error
	xml_generator("generic","error",$error,"",$cfg);
}
?>