<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="countries">
	<xsl:param name="selectname" select="'none'"/>
	<xsl:param name="message" select="'- - - - - - -'"/>
	<xsl:param name="optionvalue" select="'all'"/>
	<xsl:param name="optioncontent" select="'all'"/>
	<xsl:param name="optionselected" select="' '"/>
	<xsl:param name="onchange" select="''"/>
	<xsl:variable name="lng" select="document(concat('../language/',$language,'/country.xml'))/c"/>
	<select class="t2">
		<xsl:attribute name="name"><xsl:value-of select="$selectname"/></xsl:attribute>
		<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
		<option value=""><xsl:value-of select="$message"/></option>
		<xsl:for-each select="$lng/country">
			<option>
				<xsl:if test="$optionselected=name">
					<xsl:attribute name="selected">selected</xsl:attribute>
				</xsl:if>
				<xsl:if test="$optionselected=dialcode">
					<xsl:attribute name="selected">selected</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="$optionvalue='dialcode'">
							<xsl:value-of select="dialcode"/>
						</xsl:when>
						<xsl:when test="$optionvalue='name'">
							<xsl:value-of select="name"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="name"/>
							<xsl:value-of select="'_'"/>
							<xsl:value-of select="dialcode"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:choose>
					<xsl:when test="$optioncontent='dialcode'">
						<xsl:value-of select="dialcode"/>
					</xsl:when>
					<xsl:when test="$optioncontent='name'">
						<xsl:value-of select="name"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="name"/>
						<xsl:value-of select="' ('"/>
						<xsl:value-of select="dialcode"/>
						<xsl:value-of select="')'"/>
					</xsl:otherwise>
				</xsl:choose>
			</option>
		</xsl:for-each>
	</select>
</xsl:template>

</xsl:stylesheet>