<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/processemail"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'generic'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="generic"/>
					<input type="hidden" name="function" value="email"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="message">
							<tr>
								<td class="h t1">
									<xsl:value-of select="$lng/type"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/subject"/>
								</td>
								<td class="ha t1">
									<xsl:value-of select="$lng/message"/>
								</td>
							</tr>
						<xsl:for-each select="message">
							<tr>
								<td class="h2b t2">
									<xsl:if test="class='error'">
										<xsl:attribute name="class">h2b e</xsl:attribute>
									</xsl:if>							
									<xsl:value-of select="type"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="subject"/>
								</td>
								<td class="h2c t2">
									<pre class="t2">
										<xsl:value-of select="text"/>
									</pre>
								</td>
							</tr>
						</xsl:for-each>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
