<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="header">
	<xsl:param name="module" select="'generic'"/>
	<xsl:variable name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
	<xsl:if test="error_text or error">
	<div id="error">
		<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
			<!-- API error -->
			<xsl:if test="error_text">
				<tr><td align="left" class="t1"><xsl:value-of select="$lng/genericerror"/></td></tr>
				<tr>
					<td align="left" class="e">
						<ul>
							<xsl:for-each select="error_text">
								<li><xsl:value-of select="."/></li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</xsl:if>
			<!-- Module error -->
			<xsl:if test="error">
				<tr><td align="left" class="t1"><xsl:value-of select="$lng/moduleerror"/></td></tr>
				<tr>
					<td align="left" class="e">
						<ul>
							<xsl:variable name="err" select="document(concat('../../', $module ,'/language/', $language, '/error.xml'))/e/error"/>
							<xsl:for-each select="error">
								<xsl:variable name="id" select="."/>
									<li>
										<xsl:if test="/response/user/errorcodes">
											<xsl:value-of select="$id"/><xsl:value-of select="':'"/>
										</xsl:if>
										<xsl:value-of select="$err[@id=$id]"/>
									</li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</xsl:if>
		</table>
	</div>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>