<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="languages">
	<xsl:param name="selectname" select="'language'"/>
	<xsl:param name="message" select="''"/>
	<xsl:param name="optionselected" select="' '"/>
	<xsl:param name="onchange" select="''"/>
	<xsl:variable name="lng" select="document(concat('../language/',$language,'/language.xml'))/l"/>
	<select class="t2">
		<xsl:attribute name="name"><xsl:value-of select="$selectname"/></xsl:attribute>
		<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
		<option><xsl:value-of select="$message"/></option>
		<xsl:for-each select="$lng/langcode">
			<option>
				<xsl:if test="$optionselected=name">
					<xsl:attribute name="selected">selected</xsl:attribute>
				</xsl:if>
				<xsl:if test="$optionselected=isocode">
					<xsl:attribute name="selected">selected</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="value"><xsl:value-of select="isocode"/></xsl:attribute>
				<xsl:value-of select="isocode"/>
				<xsl:value-of select="' ('"/>
				<xsl:value-of select="name"/>
				<xsl:value-of select="')'"/>
			</option>
		</xsl:for-each>
	</select>
</xsl:template>
	
<xsl:template name="language_value">
	<xsl:param name="iso" select="'en'"/>
	<xsl:variable name="lng" select="document(concat('../language/',$language,'/language.xml'))/l"/>
	<xsl:value-of select="$iso"/>
	<xsl:for-each select="$lng/langcode">
		<xsl:if test="$iso=isocode">
			<xsl:value-of select="' ('"/>
			<xsl:value-of select="name"/>
			<xsl:value-of select="')'"/>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>