<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="top">
	<xsl:param name="showcategory" select="'0'"/>
	<xsl:param name="showquantity" select="'0'"/>
	<xsl:variable name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
	<xsl:if test="$lng/rfqnotice">
		<tr>
			<td colspan="2" class="h1 t1">
				<xsl:for-each select="$lng/rfqnotice">
					<xsl:value-of select="' '"/><xsl:value-of select="."/><br/>
				</xsl:for-each>
			</td>
		</tr>
		<tr>
			<td colspan="2"><br/></td>
		</tr>
	</xsl:if>
	<xsl:if test="$showcategory='1'">
		<tr>
			<td align="right" width="110" class="t1"><xsl:value-of select="$lng/category"/></td>
			<td align="left" width="270">
				<select name="category" onChange="changesub();changebrand();" class="t2">
					<option value="">
						<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/category"/>
					</option>
					<xsl:variable name="selectedcat" select="tender/category"/>
					<xsl:for-each select="category">
						<xsl:variable name="categoryid" select="id"/>
						<xsl:choose>
							<xsl:when test="$categoryid=$selectedcat">
								<option value="{$categoryid}" selected="selected"><xsl:value-of select="name"/></option>
							</xsl:when>
							<xsl:otherwise>
								<option value="{$categoryid}"><xsl:value-of select="name"/></option>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</select>
			</td>
		</tr>
		<tr>
			<td align="right" width="110" class="t1"><xsl:value-of select="$lng/subcat"/></td>
			<td align="left" width="270">
				<select name="subcat" class="t2">
					<option value="" selected="selected">
						<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/category"/>
					</option>
				</select>
			</td>
		</tr>
	</xsl:if>
	<tr>
		<td align="right" width="110" class="t1"><xsl:value-of select="$lng/brand"/></td>
		<td align="left" width="270">
			<select class="t2" onchange="brandupdate(brand,this)">
				<option value="" selected="selected">
					<xsl:value-of select="$lng/select"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/brand"/>
				</option>
				<xsl:for-each select="category/brand">
					<option value="{.}"><xsl:value-of select="."/></option>
				</xsl:for-each>
			</select>
			<xsl:variable name="brand" select="tender/brand"/>
			<font  class="t1"><xsl:value-of select="' '"/><xsl:value-of select="$lng/other"/><xsl:value-of select="' '"/></font>
			<input type="text" name="brand" size="10" class="t2" value="{$brand}"/>
		</td>
	</tr>
	<xsl:if test="$showquantity='1'">
		<tr>
			<xsl:variable name="quantity" select="tender/quantity"/>
			<td align="right" width="110" class="t1">
				<xsl:value-of select="$lng/quantity"/><xsl:value-of select="'  '"/>
			</td>
			<td align="left" width="270">
				<input type="text" name="quantity" size="4" class="t2" value="1"/>
				<input type="hidden" name="quantitymessage" value="{$lng/quantitymessage}"/>
			</td>
		</tr>
	</xsl:if>
	<tr>
		<xsl:variable name="model" select="tender/model"/>
		<td align="right" width="110" class="t1"><xsl:value-of select="$lng/model"/></td>
		<td align="left" width="270"><input type="text" name="model" size="20" class="t2" value="{$model}"/></td>
	</tr>
</xsl:template>

<xsl:template name="bottom">
	<xsl:param name="showbudget" select="'0'"/>
	<xsl:param name="showlens" select="'0'"/>
	<xsl:param name="showshuttle" select="'0'"/>
	<xsl:param name="showspeaker" select="'0'"/>
	<xsl:param name="showprinter" select="'0'"/>
	<tr>
		<xsl:variable name="quote" select="tender/quote"/>
		<td align="right" width="110" class="t1">
			<xsl:value-of select="$lng/quote"/><xsl:value-of select="' '"/><xsl:value-of select="/response/localprecurrency"/>
		</td>
		<td align="left" width="270">
			<input type="text" name="quote" size="8" class="t2" value="0.00"/>
		</td>
		<td align="left" width="110" class="t1">
			<xsl:value-of select="/response/localpostcurrency"/>
		</td>		
	</tr>
	<xsl:if test="$showbudget='1'">
		<tr>
			<xsl:variable name="budget" select="tender/budget"/>
			<td align="right" width="110" class="t1">
				<xsl:value-of select="$lng/budget"/><xsl:value-of select="' '"/><xsl:value-of select="/response/localprecurrency"/>
			</td>
			<td align="left" width="270">
				<input type="text" name="budget" size="8" class="t2" value="0.00"/>
			</td>
			<td align="left" width="110" class="t1">
				<xsl:value-of select="/response/localpostcurrency"/>
			</td>			
		</tr>
	</xsl:if>
	<tr>
		<td colspan="2"><br/></td>
	</tr>
	<tr>
		<td align="center" colspan="2">
			<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
				<tr>
					<td align="right" class="t2" colspan="3">
						<xsl:if test="$showprinter='1'">
							<input type="submit" name="action[printer]" value="{$lng/addprinter}" class="t2"/>
							<xsl:value-of select="' '"/>
						</xsl:if>
						<xsl:if test="$showlens='1'">
							<input type="submit" name="action[lens]" value="{$lng/addlens}" class="t2"/>
							<xsl:value-of select="' '"/>
						</xsl:if>
						<xsl:if test="$showshuttle='1'">
							<input type="submit" name="action[shuttle]" value="{$lng/addshuttle}" class="t2"/>
							<xsl:value-of select="' '"/>
						</xsl:if>
						<xsl:if test="$showspeaker='1'">
							<input type="submit" name="action[speakers]" value="{$lng/addspeakers}" class="t2"/>
							<xsl:value-of select="' '"/>
						</xsl:if>
						<input type="submit" name="action[submit]" value="{$lng/submit}" class="t2"/>
					</td>
					
				</tr>
				<tr>
					<td colspan="3"><br/></td>
				</tr>
				<xsl:for-each select="product[position() mod 3 = 1]">
					<tr>
						<xsl:for-each select=".|following-sibling::product[position() &lt; 3]">
							<xsl:variable name="product" select="name"/>
							<xsl:variable name="button">
								<xsl:value-of select="$lng/*[local-name(.)=$product]"/>
							</xsl:variable>
							<td class="g" align="left">
								<xsl:if test="status='true'">
									<input type="submit" name="action[{$product}]" value="{$button}" class="t2"/>
								</xsl:if>
								<xsl:if test="status='false'">
									<xsl:value-of select="' '"/><xsl:value-of select="name"/>
								</xsl:if>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</table>
		</td>
	</tr>
</xsl:template>

<xsl:template name="basket">
	<xsl:if test="shopping/product">
		<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
			<tr>
				<td align="left" class="h t1" colspan="5">
					<xsl:value-of select="$lng/shopheader"/><xsl:value-of select="' '"/><xsl:value-of select="shopping/rfq_number"/>
				</td>
			</tr>
			<tr>
				<td align="left" class="h1b t1">
					<xsl:value-of select="$lng/brand"/>
				</td>
				<td align="left" class="h1c t1">
					<xsl:value-of select="$lng/model"/>
				</td>
				<td align="left" class="h1c t1">
					<xsl:value-of select="$lng/des"/>
				</td>
				<td align="left" class="h1c t1">
					<xsl:value-of select="$lng/quote"/>
				</td>
			</tr>
			<xsl:for-each select="shopping/product">
				<tr>
					<td align="left" class="h2b t">
						<xsl:value-of select="brand"/>
					</td>
					<td align="left" class="h2c t">
						<xsl:value-of select="model"/>
					</td>
					<td align="left" class="h2c t">
						<xsl:value-of select="description"/>
					</td>
					<td align="left" class="h2c t">
						<xsl:value-of select="/response/localprecurrency"/><xsl:value-of select="quote"/><xsl:value-of select="/response/localpostcurrency"/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

<xsl:template name="brandscript">
	function brandupdate(first,second) {
		first.value = second.value;
	}
</xsl:template>

</xsl:stylesheet>