<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="./footer.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/success"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header"><xsl:value-of select="$lng/success"/></div>
		<div id="content">
			<div id="main">
				<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<!-- API error -->
					<xsl:if test="error_text">
						<tr>
							<td align="left" class="t">
								<ul>
									<xsl:for-each select="error_text">
										<xsl:value-of select="."/>
											<xsl:if test="position()!=last()">
												<br/>
											</xsl:if>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</div>
	</div>
<xsl:if test="refresh">
	<script>
		setTimeout('refresh()',1000);
		function refresh() {
	<xsl:choose>
		<xsl:when test="offsite">
			window.location.href = "index.php";
		</xsl:when>
		<xsl:otherwise>
			parent.menu.location.reload();
			location.href = "./main.php?module=session&amp;function=login";
		</xsl:otherwise>
	</xsl:choose>
		}
	</script>
</xsl:if>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>