<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Main page
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// set that no errors are echo'd as that messes up xml
ini_set("display_errors", "0");

require('modules/settings/config.inc.php');
// load required files
if(!isset($cfg['installed']) || $cfg['installed']) {
	// initiate session
	session_start();
	// remove install session
	if($_SESSION['ts_classification'] == "-1") {
		// reset session
		unset($_SESSION['ts_id']);
		unset($_SESSION['ts_classification']);
		unset($_SESSION['ts_name']);
		unset($_SESSION['ts_surname']);
		unset($_SESSION['ts_username']);
		unset($_SESSION['tendersystem_tester']);
	}
	if($_REQUEST['next_module'] && $_REQUEST['next_function']) {
		$_SESSION['next_module'] = $_REQUEST['next_module'];
		$_SESSION['next_function'] = $_REQUEST['next_function'];
		$_SESSION['next_call_id'] = $_REQUEST['next_call_id'];
	}
	// set theme
	if(isset($_REQUEST['theme'])) {
		$_SESSION['ts_theme'] = $_REQUEST['theme'];
	}
	// internet explorer 6 fix when using back button
	header("Cache-control: private");
	// output
	$output = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\r\n";
	$output.= "<html>\r\n";
	$output.= "<head>\r\n";
	$output.= "<title>";
	$output.= $cfg['header'];
	$output.= "</title>\r\n";
	$output.= "<META name=\"description\" content=\"TenderSystem\"/>\r\n";
	$output.= "<meta name=\"generator\" content=\"TenderSystem v".$cfg['version']." www.tendersystem.com\"/>\r\n";
	$output.= "<meta name=\"robots\" content=\"index,follow\"/>\r\n";
	$output.= "<meta name=\"rating\" content=\"Private\"/>\r\n";
	$output.= "<link rel=\"shortcut icon\" href=\"favicon.ico\"/>\r\n";
	$output.= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
	$output.= "</head>\r\n";
	$output.= "<frameset rows=\"106,*\" border=\"0\">\r\n";
	$output.= "<frame name=\"menu\" src=\"menu.php\" noresize marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "<frameset cols=\"130,*\" border=\"0\">\r\n";
	$output.= "<frame name=\"left\" src=\"left.php\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "<frame name=\"main\" src=\"main.php?module=session&function=login\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"auto\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "</frameset>\r\n";
	$output.= "<noframes>\r\n";
	$output.= "<body>\r\n";
	$output.= "<p>This page uses frames, but your browser doesn't support them.</p>\r\n";
	$output.= "</body>\r\n";
	$output.= "</noframes>\r\n";
	$output.= "</frameset>\r\n";
	// display
	echo $output; 
} else {
	if(!function_exists("session_start")) {
		echo "Must have Session Module installed";
		die();	
	}
	// initiate session
	session_start();
	// reset session
	unset($_SESSION['ts_id']);
	unset($_SESSION['ts_classification']);
	unset($_SESSION['ts_name']);
	unset($_SESSION['ts_surname']);
	unset($_SESSION['ts_username']);
	unset($_SESSION['tendersystem_tester']);
	$_SESSION['ts_classification'] = "-1";
	$_SESSION['ts_id'] = "Install";
	// set theme
	if(isset($_REQUEST['theme'])) {
		$_SESSION['ts_theme'] = $_REQUEST['theme'];
	}
	// internet explorer 6 fix when using back button
	header("Cache-control: private");
	// output
	$output = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\r\n";
	$output.= "<html>\r\n";
	$output.= "<head>\r\n";
	$output.= "<title>";
	$output.= $cfg['header'];
	$output.= "</title>\r\n";
	$output.= "<META name=\"description\" content=\"TenderSystem\"/>\r\n";
	$output.= "<meta name=\"generator\" content=\"TenderSystem v".$cfg['version']." www.tendersystem.com\"/>\r\n";
	$output.= "<meta name=\"robots\" content=\"index,follow\"/>\r\n";
	$output.= "<meta name=\"rating\" content=\"Private\"/>\r\n";
	$output.= "<link rel=\"shortcut icon\" href=\"favicon.ico\"/>\r\n";
	$output.= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
	$output.= "</head>\r\n";
	$output.= "<frameset rows=\"106,*\" border=\"0\">\r\n";
	$output.= "<frame name=\"menu\" src=\"menu.php\" noresize marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "<frameset cols=\"130,*\" border=\"0\">\r\n";
	$output.= "<frame name=\"left\" src=\"left.php?module=install\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "<frame name=\"main\" src=\"main.php?module=install&function=install\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"auto\" border=\"0\" frameborder=\"0\" framespacing=\"0\">\r\n";
	$output.= "</frameset>\r\n";
	$output.= "<noframes>\r\n";
	$output.= "<body>\r\n";
	$output.= "<p>This page uses frames, but your browser doesn't support them.</p>\r\n";
	$output.= "</body>\r\n";
	$output.= "</noframes>\r\n";
	$output.= "</frameset>\r\n";
	// display
	echo $output;
}
?>