<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Left menu generator
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// load required files
include('modules/generic/generic.php');

// field request errors and type 
$fields_request = array (
	'module'		=> array(),
	'function'		=> array()
);

get_request($fields_request,$info,$error,$cfg);

if ($info['module']) {
	if ($info['module'] == "calculator") {
		// generate and display the xml
		xml_generator('menu','left_calculator',"","",$cfg);
	} elseif($info['module'] && $info['function'] && file_exists('./modules/'.$info['module'].'/left_'.$info['function'].'.php')) {
		include('./modules/'.$info['module'].'/left_'.$info['function'].'.php');
	} elseif($info['module'] && file_exists('./modules/'.$info['module'].'/left.php')) {
		include('./modules/'.$info['module'].'/left.php');
	} else {
		// generate and display the xml
		// e19 - Module/Function does not exists
		xml_generator('generic','error',"e19","",$cfg);
	}
} else {
	if ($_SESSION['ts_xslt'] == "no" && $cfg['menu']['lefthtml']) {
		// set the left display
		$left_code['code'] = "&lt;tr&gt;&lt;td&gt;";
		$left_code['code'].= str_replace(array("[","]","{quote}","{and}"),array("&lt;","&gt;","\"","&amp;"),$cfg['menu']['lefthtml']);
		$left_code['code'].= "&lt;/td&gt;&lt;/tr&gt;";
	}
	// generate and display the xml
	xml_generator('menu','left',"",$left_code,$cfg);
}
?>