<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Main generator
* @package TenderSystem
* @subpackage generic
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// load required files
require(getcwd().'/modules/generic/generic.php');
// set the next required request fields
$next_module = $_REQUEST['next_module'];
$next_function = $_REQUEST['function'];
if($next_module && $next_function) {
	// somehow session and logout is posted when logging out
	if ($next_module) {
		$_SESSION['next_module'] = $next_module;
		$_SESSION['next_function'] = $next_function;
	}
	// set the login page
	require(getcwd()."/modules/session/login.php");
} else {
	// field request errors and type
	// e16 - Missing module
	// e17 - Missing function
	$ts_fields_request = array (
		'module'		=> array("e16"),
		'function'		=> array("e17")
	);
	$required_paramaters = get_request($ts_fields_request,$ts_info,$ts_error,$cfg);
	// determine if no module and function
	if (!$ts_info['module'] && !$ts_info['function']) {
		$ts_info['module'] = "session";
		$ts_info['function'] = "login";
		$required_paramaters = TRUE;
		$info['offsite'] = TRUE;
	}
	if($required_paramaters) {
		if(!file_exists(getcwd()."/modules/".$ts_info['module'])) {
			// generate and display the xml
			// e2 - module does not exists
			xml_generator('generic','error',"e2","",$cfg);
		} elseif(!file_exists(getcwd()."/modules/".$ts_info['module']."/".$ts_info['function'].".php")) {
			// generate and display the xml
			// e1 - Function File does not exists
			xml_generator('generic','error',"e1","",$cfg);
		} else {
			if(file_exists(getcwd()."/modules/".$ts_info['module']."/config.inc.php")) {
				// include config settings of module
				include(getcwd()."/modules/".$ts_info['module']."/config.inc.php");
			}
			if($ts_info['module'] != "generic" && file_exists(getcwd()."/modules/".$ts_info['module']."/generic.php")) {
				// include generic function of module
				include(getcwd()."/modules/".$ts_info['module']."/generic.php");
			}
			// include execution file
			require(getcwd()."/modules/".$ts_info['module']."/".$ts_info['function'].".php");
		}
	} else {
		xml_generator('generic','error',$ts_error,"",$cfg);
	}
}
?>