<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

// DATE CREATED : Apr 1, 2006

/**
* Give ADODB driver details
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/
$xml = file_get_contents("modules/install/language/".$_SESSION['ts_lang']."/default.xml");

// adodb driver used
$driver['adodb'] = "postgres7";
// php extension need
$driver['extension'] = "pgsql";
// transaction support
$driver['transaction'] = TRUE;
// supports unique
$driver['unique'] = TRUE;
// supports references
$driver['reference'] = TRUE;
// driver status
// 1 - Well Tested
// 2 - Basics was Tested
// 3 - Only Install Tested
// 4 - Nothing Tested
$driver['status'] = "1";
// function to check for extra error message if connection fails
$driver['check_error'] = "pg_last_error";
$driver['name'] = event_parser('<headerpostgres7>','</headerpostgres7>',$xml);

// START --- need input to setup driver ---
$input['description'] = event_parser('<databasename>','</databasename>',$xml);
$input['name'] = "database";
$input['value'] = "tendersystem";
$input['type'] = "text";
$driver['input'][] = $input;
unset($input);

$input['description'] = event_parser('<host>','</host>',$xml);
$input['name'] = "host";
$input['value'] = "localhost";
$input['type'] = "text";
$driver['input'][] = $input;
unset($input);

$input['description'] = event_parser('<port>','</port>',$xml);
$input['name'] = "port";
$input['value'] = "5432";
$input['type'] = "text";
$driver['input'][] = $input;
unset($input);

$input['description'] = event_parser('<username>','</username>',$xml);
$input['name'] = "username";
$input['value'] = "";
$input['type'] = "text";
$driver['input'][] = $input;
unset($input);

$input['description'] = event_parser('<password>','</password>',$xml);
$input['name'] = "password";
$input['value'] = "";
$input['type'] = "password";
$driver['input'][] = $input;
unset($input);

/* $input['description'] = event_parser('<mysqlclientcompress>','</mysqlclientcompress>',$xml);
$input['name'] = "clientcompress";
$input['value'] = "1";
$input['type'] = "checkbox";
$driver['input'][] = $input;
unset($input); */

// END --- need input to setup driver ---

if(extension_loaded($driver['extension'])) {
	$params['connections'][] = $driver;
}
$params['all_connections'][] = $driver;
unset($driver);
	
function postgres7_field_request () {
	// field request errors and type 
	$fields_request = array (
		'database'			=> array("e1"),
		'host'				=> array("e3"),
		'username'			=> array("e4"),
		'password'			=> array("e5"),
		'port'				=> array()
	);
	return $fields_request;
}

function postgres7_dsn_request (&$info) {
	$pwd = urlencode($info['password']);
	$host = $info['host'];
	$user = $info['username'];
	$db = $info['database'];
	$dsn = "postgres7://$user:$pwd@$host/$db?persist";
	if($info['port']) {
		$dsn.="&port=".$info['port'];
	}
	return $dsn;
}

function postgres7_type_request (&$info) {
	$type_replace['blob'] = "bytea";
	$type_replace['money']	= "decimal(12,2)";
	$type_replace['percentage'] = "decimal(5,2)";
	$type_replace['text'] = "varchar";
	return $type_replace;
}
?>
