<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Main file
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'		=> array(),
	'install'		=> array(),
	'accept'		=> array(),
	'installtype'	=> array(),
	'databasetype'	=> array(),
	'language'		=> array(),
	'upload'		=> array()		
);
get_request($fields_request,$action,$error,$cfg);
if($action['action'] && $action['installtype'] && $action['databasetype']) {
	require(getcwd()."/modules/install/drivers/".$action['databasetype'].".php");
	xml_generator("install",$action['installtype']."_generic","",$params,$cfg);
	// generate
	/* $function = $action['installtype']."_".$action['databasetype'];
	xml_generator("install",$function,"",$params,$cfg); */
} elseif($action['install'] && $action['accept']) {
	// check the if config files are writable
	$files = examinedir(".",TRUE);
	$params['noinstall'] = "0";
	foreach($files as $value) {
		if(strpos($value,"config.inc.php") && is_file($value)) {
			$config_file['readable'] = "1";
			$config_file['writable'] = "1";
			$config_file['name'] = $value;
			if(!is_readable($value)) {
				$config_file['readable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_writable($value)) {
				$config_file['writable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_readable($value) || !is_writable($value)) {
				$params['config_file'][] = $config_file;
			}
		}
		if(strpos($value,"upload") && is_dir($value)) {
			$config_file['readable'] = "1";
			$config_file['writable'] = "1";
			$config_file['name'] = $value;
			if(!is_readable($value)) {
				$config_file['readable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_writable($value)) {
				$config_file['writable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_readable($value) || !is_writable($value)) {
				$params['config_file'][] = $config_file;
			}
		}
		if(strpos($value,"rollback") && is_dir($value)) {
			$config_file['readable'] = "1";
			$config_file['writable'] = "1";
			$config_file['name'] = $value;
			if(!is_readable($value)) {
				$config_file['readable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_writable($value)) {
				$config_file['writable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_readable($value) || !is_writable($value)) {
				$params['config_file'][] = $config_file;
			}
		}
		if(strpos($value,".log") && strpos($value,"log/")) {
			$config_file['readable'] = "1";
			$config_file['writable'] = "1";
			$config_file['name'] = $value;
			if(!is_readable($value)) {
				$config_file['readable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_writable($value)) {
				$config_file['writable'] = "0";
				$params['noinstall'] = "1";
			}
			if(!is_readable($value) || !is_writable($value)) {
				$params['config_file'][] = $config_file;
			}
		}
	}
	if(extension_loaded('xslt')) {
		$params['sablotron'] = "1";
	}
	if(extension_loaded('xsl')) {
		$params['libxslt'] = "1";
	}
	if(extension_loaded('curl')) {
		$params['curl'] = "1";
	}
	if(extension_loaded('zlib')) {
		$params['zlib'] = "1";
	}
	if(extension_loaded('xml')) {
		$params['xml'] = "1";
	}
	if(extension_loaded('pcre')) {
		$params['pcre'] = "1";
	}
	// databases
	/*if(extension_loaded("mysql")) {
		$params['mysql'] = "1";
	}
	if(extension_loaded("mysqli")) {
		$params['mysqli'] = "1";
	}
	if(extension_loaded('pgsql')) {
		$params['postgres'] = "1";
	}
	if(extension_loaded('oci8')) {
		$params['OCIPLogon'] = "1";
	}
	if(extension_loaded('interbase')) {
		$params['ibase_pconnect'] = "1";
	}*/
	// check for available connections
	$driver_files = list_files(getcwd()."/modules/install/drivers");
	foreach($driver_files as $driver_file) {
		include($driver_file);
	}
	// send message to api
	xml_generator("install","install","",$params,$cfg);
} elseif($action['language']) {
	$keys = array_keys($action['language']);
	$_SESSION['ts_lang'] = $keys[0];
	if(file_exists(getcwd()."/modules/install/language/".$_SESSION['ts_lang']."/start.html")) {
		$html = file_get_contents(getcwd()."/modules/install/language/".$_SESSION['ts_lang']."/start.html");
		echo $html;
	} elseif(file_exists(getcwd()."/modules/install/language/".$cfg['language']."/start.html")) {
		$html = file_get_contents(getcwd()."/modules/install/language/".$cfg['language']."/start.html");
		echo $html;
	} elseif(file_exists(getcwd()."/modules/install/language/en/start.html")) {
		$html = file_get_contents(getcwd()."/modules/install/language/en/start.html");
		echo $html;
	} else {
		// e39 - Cannot find installation file
		xml_generator("install","install","e39",$params,$cfg);
	}	
} else {
	// menu item for administrator
	$language = get_languages();
	
	// go through each language
	foreach($language as $value) {
		$xml = file_get_contents("modules/install/language/".$value."/default.xml");
		if($xml) {
			$item['welcomeinstall'] = event_parser('<welcomeinstall>','</welcomeinstall>',$xml);
			$item['installin'] = event_parser('<installin>','</installin>',$xml);
			$item['loadanotherlanguage'] = event_parser('<loadanotherlanguage>','</loadanotherlanguage>',$xml);
			$item['language'] = $value;
			$params['languageinfo'][] = $item;
		}
	}
	xml_generator("install","language_select","",$params,$cfg);
}
?>