<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Administration information
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// include required classes
require(getcwd().'/application/include/modules/password/class/password.class.php');
require(getcwd().'/application/include/modules/user/class/user.class.php');
require(getcwd().'/application/include/modules/user/class/admin.class.php');
require(getcwd().'/application/include/modules/organisation/class/organisation.class.php');
require(getcwd().'/application/include/modules/generic/class/database.class.php');
// ensure that no sessions present
$action = sanitise($_POST['action']);
if($action) {
	// field request errors and type 
	$fields_request = array (
		'name'			=> array("e6",	REQUEST_ANY,	FORMAT_UCWORDS),
		'surname'		=> array("e7",	REQUEST_ANY,	FORMAT_UCWORDS),
		'phone_work'	=> array("e8",	REQUEST_PHONE,	FORMAT_PHONE, 	"e40"),
		'phone_prefix'	=> array("e9",	REQUEST_NUMBER,	FORMAT_NONE,	"e41"),
		'phone_fax'		=> array("e10",	REQUEST_PHONE,	FORMAT_PHONE,	"e42"),
		'phone_mobile'	=> array("e11",	REQUEST_PHONE,	FORMAT_PHONE,	"e43"),
		'email'			=> array("e12",	REQUEST_EMAIL,	FORMAT_NONE,	"e20"),
		'companyname'	=> array("e13",	REQUEST_ANY,	FORMAT_UCWORDS)
	);
	// get data
	if(get_request($fields_request,$info,$error,$cfg)) {
		$user['name'] = $info['name'];
		$user['surname'] = $info['surname'];
		$branch['phone_work'] = $user['phone_work'] = $info['phone_work'];
		$branch['phone_prefix'] = $user['phone_prefix'] = $info['phone_prefix'];
		$branch['phone_fax'] = $user['phone_fax'] = $info['phone_fax'];
		$user['phone_mobile'] = $info['phone_mobile'];
		$branch['email'] = $user['email'] = $info['email'];
		$branch['name'] = $org['name'] = $org['registered_name'] = $info['companyname'];
		$branch['name'].=" HQ";
		// include required files
		require(getcwd().'/application/include/modules/settings/config.inc.php');	
		// set application executable file location
		$cfg['file'] = getcwd().'/application/include/';
		$cfg['directory'] = getcwd().'/application';
		// create database connection
		$conn = &ADONewConnection($cfg['dsn']['0']['conn']);
		if (!$conn) {
			// incorrect database configurations
			$error_code[] = "e14";		
		 	// generate and display the xml
			xml_generator("install","newinstall_admin",$error_code,"",$cfg);
		}
		$new_database = new database;
		// set id's
		$user['administrator'] = $branch['created_by'] = $org['rep_user_id'] = $org['created_by'] = $user['created_by'] = $user['id'] = $new_database->get_next_id("~users",$cfg,$conn);
		$branch['organisation'] = $org['id'] = $user['organisation'] = $new_database->get_next_id("~organisation",$cfg,$conn);
		$user['branch'] = $branch['id'] = $new_database->get_next_id("~organisation_branch",$cfg,$conn);
		// set additional required information
		$org['classification'] = "3";
		$org['vat_number'] = "XXXX";
		$org['registration_number'] = "XXXX";
		$org['rep_position'] = "Administrator";
		$org['status'] = "1";
		// create a organisation object
		$new_org = new organisation;
		$cfg['file'] = "./application/include/";
		// start sql transaction
		$conn->StartTrans();
		if (!$new_org->create_organisation($org,$cfg,$conn)) {
			// generate and display the xml error
			xml_generator("install","newinstall_admin",$new_org->error,"",$cfg);
		}
		require(getcwd().'/application/include/modules/branch/class/branch.class.php');
		// set branch params
		$branch['primary_address_street'] = "not set";
		$branch['primary_address_city'] = "not set";
		$branch['primary_address_state'] = "not set";
		$branch['primary_address_postalcode'] = "not set";
		$branch['primary_address_country'] = "not set";
		$branch['alt_address_street'] = "not set";
		$branch['alt_address_city'] = "not set";
		$branch['alt_address_state'] = "not set";
		$branch['alt_address_postalcode'] = "not set";
		$branch['alt_address_country']= "not set";
		$branch['branch_comment']= "none";
		$branch['status'] = "1";
		// instantiate the user object
		$new_branch = new branch;
		if (!$new_branch->create_branch($branch,$cfg,$conn)) {
			// generate and display the xml error
			xml_generator("install","newinstall_admin",$new_branch->error,"",$cfg);
		}
		// set other users params
		$user['username'] = "admin";
		$user['status'] = "2";
		$user['classification'] = "3";
		$user['permission'] = "2";
		$user['language'] = $cfg['language'];
		$user['theme'] = $cfg['theme'];
		// instantiate the user object
		$new_user = new user;
		if (!$new_user->create_user($user,$cfg,$conn)) {
			// generate and display the xml error
			xml_generator("install","newinstall_admin",$new_user->error,"",$cfg);
		}
		// instantiate the password object
		$new_password = new password;
		// set the password
		$password = "tendersystem";
		$hash_password = $new_password->hash_password($password,$cfg); 
		if (!$new_user->update_password($hash_password,$user['id'],"2",$cfg,$conn)) {
			// generate and display the xml error
			xml_generator("install","newinstall_admin",$new_user->error,"",$cfg);
		}
		// complete sql transaction
		$conn->CompleteTrans();
		$conn->close();
		// generate the xml reponse
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n";
		$xml.= "<?xml-stylesheet type=\"text/xsl\" href=\"./modules/install/templates/success.xsl\" ?>\r\n\r\n";
		$xml.= "<response>\r\n";
		$xml.= "<user>\r\n";
		$xml.= "<name>".$user['name']."</name>\r\n";
		$xml.= "<surname>".$user['surname']."</surname>\r\n";
		$xml.= "<theme>".$user['theme']."</theme>\r\n";
		$xml.= "<language>".$user['language']."</language>\r\n";
		$xml.= "<username>".$user['username']."</username>\r\n";
		$xml.= "<password>".$password."</password>\r\n";
		$xml.= "<index>./index.php?username=".$user['username']."</index>\r\n";
		$xml.= "</user>";
		// clear session
		unset($_SESSION['ts_id']);
		// display the generated xml
		$display_response = display_response($xml,$cfg);
	} else {
		 // generate and display the xml error
		xml_generator("install","newinstall_admin",$error,$info,$cfg);
	}
} else {
	// send message to api
	xml_generator("install","error","e25",$params,$cfg);
}
?>