<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Install postgre7 database
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'			=> array("e25")
);
if(get_request($fields_request,$action,$error,$cfg)) {
	// field request errors and type 
	$fields_request = array (
		'database'			=> array("e1"),
		'host'				=> array("e3"),
		'username'			=> array("e4"),
		'password'			=> array("e5"),
		'port'				=> array(),
		'genid'				=> array(),
		'transaction'		=> array(),
		'dbprefix'			=> array()
	);
	// get data
	if(get_request($fields_request,$info,$error,$cfg)) {
		$pwd = urlencode($info['password']);
		$host = $info['host'];
		$user = $info['username'];
		$db = $info['database'];
		$dsn = "postgres7://$user:$pwd@$host/$db?persist";
		if($info['port']) {
			$dsn.="&port=".$info['port'];
		}
		// the space in front is needed
		$type_replace['blob'] = "bytea";
		$type_replace['money']	= "decimal(12,2)";
		$type_replace['percentage'] = "decimal(5,2)";
		$type_replace['text'] = "varchar";
		$result = do_database_dump($dsn,$info['dbprefix'],$cfg,$type_replace);
		if($result === TRUE) {
			$result = load_db_settings($dsn,$info['dbprefix'],$cfg,$info['genid'],$info['transaction']);
		}
		if($result === TRUE) {
			// send message to api
			xml_generator("install","newinstall_security","",$params,$cfg);
		} else {
			// send message to api
			xml_generator("install","newinstall_postgres7",$result,$params,$cfg);	
		}
	} else {
		// generate
		xml_generator("install","newinstall_postgres7",$error,$params,$cfg);
	}
} else {
	// send message to api
	xml_generator("install","error",$error,$params,$cfg);
}
?>