<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Re-install postgre7 database
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type
// e25 - No html post present
// e46 - Missing ADODB database driver type
$fields_request = array (
	'action'	=> array("e25"),
	'adodb'		=> array("e46")
);
if(get_request($fields_request,$action,$error,$cfg)) {
	require(getcwd()."/modules/install/drivers/".$action['adodb'].".php");
	$adodb_driver = $params['connections'][0]['adodb'];
	$supports_unique = $params['connections'][0]['unique'];
	$supports_references = $params['connections'][0]['reference'];
	$fn_request = $adodb_driver."_field_request";
	$dsn_request = $adodb_driver."_dsn_request";
	$type_request = $adodb_driver."_type_request";
	// database specific field request
	$fields_request = $fn_request();
	// default field request
	$fields_request['genid'] = array();
	$fields_request['dbprefix'] = array();
	$fields_request['transaction'] = array();
	// get data
	if(get_request($fields_request,$info,$error,$cfg)) {
		$function = "reinstall_generic";
		// setup dsn
		$dsn = $dsn_request($info);
		// get type replace
		$type_replace = $type_request();
		// do upgrade
		require(getcwd()."/modules/install/reinstall.php");
	} else {
		// generate
		xml_generator("install","reinstall_generic",$error,$params,$cfg);
	}
} else {
	// generate xml
	xml_generator("install","error",$error,$params,$cfg);
}
?>