<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Re-Install oracle 8 database
* @package TenderSystem
* @subpackage install
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// ensure that no sessions present
$action = sanitise($_POST['action']);
if($action) {
	// function
	$function = "reinstall_oci8";
	define('ADODB_ASSOC_CASE',0);
	// field request errors and type 
	$fields_request = array (
		'database'			=> array("e1"),
		'host'				=> array("e3"),
		'username'			=> array("e4"),
		'password'			=> array("e5"),
		'port'				=> array(),
		'charset'			=> array(),
		'dbprefix'			=> array()
	);
	// get data
	get_request($fields_request,$info,$fields_error,$cfg);
	$pwd = urlencode($info['password']);
	$host = $info['host'];
	$user = $info['username'];
	$db = $info['database'];
	$dsn = "oci8po://$user:$pwd@$host/$db";
	if($info['charset']) {
		$dsn.= "?charset=".$info['charset'];
	}
	if($info['port']) {
		$dsn.="&port=".$info['port'];
	}
	// replace certain types
	$type_replace['date'] = "char(10)";
	$type_replace['money']	= "decimal(12,2)";
	$type_replace['percentage'] = "decimal(5,2)";
	$type_replace['blob'] = "blob";
	$type_replace['time'] = "char(8)";
	$type_replace['inet'] = "varchar(24)";
	$type_replace['text'] = "varchar(255)";
	require(getcwd()."/modules/install/reinstall.php");
} else {
	// generate xml
	xml_generator("install","error","e25",$params,$cfg);
}
?>