<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/welcomeinstall"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="install"/>
					<input type="hidden" name="function" value="install"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="t1" colspan="2">
								<xsl:for-each select="$lng/thankyou">
									<xsl:value-of select="."/><br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr><td><br/></td></tr>
						<tr>
							<td colspan="3" class="h t1"><xsl:value-of select="$lng/checkconfig"/></td>
						</tr>
						<tr>
							<td class="h1b t1"><xsl:value-of select="$lng/filename"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/writable"/></td>
							<td class="h1c t1"><xsl:value-of select="$lng/readable"/></td>
						</tr>
					<xsl:if test="noinstall!='1'">
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/allconfig"/></td>
							<td class="h2c t2" align="center">
								<img border="0" valign="top">
									<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
									<xsl:attribute name="alt"><xsl:value-of select="'1'"/></xsl:attribute>
								</img>
							</td>
							<td class="h2c t2" align="center">
								<img border="0" valign="top">
									<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
									<xsl:attribute name="alt"><xsl:value-of select="'1'"/></xsl:attribute>
								</img>
							</td>
						</tr>
					</xsl:if>
				<xsl:if test="noinstall='1'">
					<xsl:for-each select="config_file">
						<tr>
							<td class="h2b t2"><xsl:value-of select="name"/></td>
							<td class="h2c t2" align="center">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="writable='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="writable"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="writable"/></xsl:attribute>
								</img>
							</td>
							<td class="h2c t2" align="center">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="readable='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="readable"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="readable"/></xsl:attribute>
								</img>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
						<tr><td><br/></td></tr>
						<tr>
							<td colspan="3" class="h t1"><xsl:value-of select="$lng/phprequired"/></td>
						</tr>
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/xslcap"/></td>
							<td class="h2c t2" align="center" colspan="2">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="sablotron='1' or libxslt='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="nosablotron"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="nosablotron"/></xsl:attribute>
								</img>
							</td>
						</tr>
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/curl"/></td>
							<td class="h2c t2" align="center" colspan="2">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="curl='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="curl"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="curl"/></xsl:attribute>
								</img>
							</td>
						</tr>
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/zlib"/></td>
							<td class="h2c t2" align="center" colspan="2">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="zlib='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="zlib"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="zlib"/></xsl:attribute>
								</img>
							</td>
						</tr>
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/xmlcap"/></td>
							<td class="h2c t2" align="center" colspan="2">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="xml='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="xmlcap"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="xmlcap"/></xsl:attribute>
								</img>
							</td>
						</tr>
						<tr>
							<td class="h2b t2"><xsl:value-of select="$lng/pcre"/></td>
							<td class="h2c t2" align="center" colspan="2">
								<img border="0" valign="top">
									<xsl:choose>
										<xsl:when test="pcre='1'">
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/yes.gif</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src">./theme/<xsl:value-of select="$theme"/>/icon/no.gif</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:attribute name="alt"><xsl:value-of select="pcre"/></xsl:attribute>
									<xsl:attribute name="title"><xsl:value-of select="pcre"/></xsl:attribute>
								</img>
							</td>
						</tr>
					<xsl:if test="not(zlib)">
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/needzlib"/></td>
						</tr>
					</xsl:if>
					<xsl:if test="not(curl)">
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/needcurl"/></td>
						</tr>
					</xsl:if>
					<xsl:if test="not(sablotron) and not(libxslt)">
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/needsablotron"/></td>
						</tr>
					</xsl:if>
					<xsl:if test="not(xml)">
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/needxml"/></td>
						</tr>
					</xsl:if>
					<xsl:if test="not(pcre)">
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/needpcre"/></td>
						</tr>
					</xsl:if>
			<xsl:choose>
				<xsl:when test="noinstall!='1'">
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/installtype"/></td>
							<td align="left" colspan="2">
								<select name="installtype" class="t2">
									<option value="newinstall"><xsl:value-of select="$lng/newinstall"/></option>
									<option value="reinstall"><xsl:value-of select="$lng/upgrade_0_6"/></option>
									<option value="reinstall"><xsl:value-of select="$lng/reinstall"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/adodbdriver"/></td>
							<td align="left" colspan="2">
								<select name="databasetype" class="t2">
									<xsl:for-each select="connections">
										<option value="{adodb}"><xsl:value-of select="adodb"/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td></td>
							<td align="right" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
				</xsl:when>
				<xsl:otherwise>
						<tr>
							<td colspan="3" class="e"><xsl:value-of select="$lng/fixpermissions"/></td>
						</tr>
				</xsl:otherwise>
			</xsl:choose>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/installmanual"/>
				</div>
				<div id="right_content">
					<a href="./manuals/{$language}/install_manual.pdf">
						<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
						<xsl:value-of select="' '"/><xsl:value-of select="$lng/viewmanual"/>
					</a>
				</div>
			<xsl:if test="noinstall!='1'">
				<div id="right_header">
					<xsl:value-of select="$lng/installheading"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/installinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
				<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
					<tr>
					   <td class="h t1" colspan="5"><xsl:value-of select="$lng/adodbdriversother"/></td>
					</tr>
					<tr>
						<td class="h1b t1"><xsl:value-of select="$lng/adodbdrivername"/></td>
						<td class="h1c t1"><xsl:value-of select="$lng/adodbdriverdescription"/></td>
						<td class="h1c t1"><xsl:value-of select="$lng/adodbdriverextension"/></td>
						<td class="h1c t1"><xsl:value-of select="$lng/adodbdriverstransaction"/></td>
						<td class="h1c t1"><xsl:value-of select="$lng/adodbdriverstatus"/></td>
					</tr>
					   	<xsl:for-each select="all_connections">
					<tr>
						<td class="h2b t1"><xsl:value-of select="adodb"/></td>
				   		<td class="h2c t2"><xsl:value-of select="name"/></td>
						<td class="h2c t2"><xsl:value-of select="extension"/></td>
						<td class="h2c t2">
							<xsl:choose>
								<xsl:when test="transaction='1'">
									<xsl:value-of select="$lng/yes"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$lng/no"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="h2c t2">
							<xsl:choose>
								<xsl:when test="status='1'">
									<xsl:value-of select="$lng/adodbdriverstatus1"/>
								</xsl:when>
								<xsl:when test="status='2'">
									<xsl:value-of select="$lng/adodbdriverstatus2"/>
								</xsl:when>
								<xsl:when test="status='3'">
									<xsl:value-of select="$lng/adodbdriverstatus3"/>
								</xsl:when>
								<xsl:when test="status='4'">
									<xsl:value-of select="$lng/adodbdriverstatus4"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$lng/adodbdriverstatus5"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
						<!-- <option value="{adodb}"><xsl:value-of select="adodb"/></option>-->
						</xsl:for-each>
					</table>
			</xsl:if>
			</div>
		</div>
	</div>
	<script language="javascript">
		parent.left.location.reload();
	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
