<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="install"/>
					<input type="hidden" name="function" value="install"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr><td colspan="2"><br/></td></tr>
						<xsl:for-each select="languageinfo">
							<tr>
								<td class="t1">
									<xsl:value-of select="welcomeinstall"/>
								</td>
								<td align="right" class="t2">
									<xsl:value-of select="installin"/>:
									<input type="submit" name="language[{language}]" class="t2">
										<xsl:attribute name="value">
											<xsl:call-template name="language_value">
												<xsl:with-param name="iso" select="language"/>
											</xsl:call-template>
										</xsl:attribute>
									</input>
								</td>
							</tr>
							<tr>
								<td class="t2" colspan="2" align="right">
									<xsl:value-of select="loadanotherlanguage"/>
								</td>
							</tr>
							<tr><td class="h" colspan="2"></td></tr>
							<tr><td colspan="2"><br/></td></tr>
						</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
