<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data" method="post" name="report" action="left.php">
						<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td>
									<b><xsl:value-of select="$lng/install"/></b>
									<ul>
										<li>
											<a href="./manuals/{$language}/install_manual.pdf">
												<img src="./theme/{$theme}/icon/pdf.gif" border="0"/>
												<xsl:value-of select="' '"/><xsl:value-of select="$lng/installmanual"/>
											</a>
										</li>
									<xsl:for-each select="setup">
										<li>
											<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
												<xsl:value-of select="name"/>
											</a>
										</li>
									</xsl:for-each>
										<li>
											<a href="./main.php?module=install&amp;function=install" target="main">
												<xsl:value-of select="$lng/install"/>
											</a>
										</li>
									</ul>
								</td>
							</tr>
						</table>
					</form>
				</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>