<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/countries.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/admindetails"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="install"/>
					<input type="hidden" name="function" value="newinstall_admin"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/name"/></td>
							<td align="left"><input type="text" name="name" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/surname"/></td>
							<td align="left"><input type="text" name="surname" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/phoneprefix"/></td>
							<td align="left" class="t2">
								<xsl:call-template name="countries">
									<xsl:with-param name="selectname" select="'phone_prefix'"/>
									<xsl:with-param name="message" select="$lng/selectphoneprefix"/>
									<xsl:with-param name="optionvalue" select="'dialcode'"/>
									<xsl:with-param name="optioncontent" select="'all'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/phonework"/></td>
							<td align="left" class="t2"><input type="text" name="phone_work" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/phonefax"/></td>
							<td align="left" class="t2"><input type="text" name="phone_fax" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/phonemobile"/></td>
							<td align="left" class="t2"><input type="text" name="phone_mobile" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/emailaddress"/></td>
							<td align="left" class="t2"><input type="text" name="email" size="32" maxlenght="255" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/companyname"/></td>
							<td align="left" class="t2"><input type="text" name="companyname" size="32" maxlenght="52" class="t2"/></td>
						</tr>
						<tr>
							<td></td>
							<td align="left">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/adminheading"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/admininstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
