<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/installingon"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="connections/name"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="install"/>
					<input type="hidden" name="function" value="newinstall_generic"/>
					<input type="hidden" name="adodb" value="{connections/adodb}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="h1 t1" colspan="2"><xsl:value-of select="$lng/databasesettings"/></td>
						</tr>
						<xsl:for-each select="connections/input">
						<tr>
							<td align="left" class="t1"><xsl:value-of select="description"/></td>
							<td align="left"><input type="{type}" name="{name}" size="12" class="t2" value="{value}"/></td>
						</tr>
						</xsl:for-each> 
						<tr>
							<td class="h1 t1" colspan="2"><xsl:value-of select="$lng/othersettings"/></td>
						</tr>
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/dbprefix"/></td>
							<td align="left"><input type="text" name="dbprefix" size="5" class="t2" value="ts_"/></td>
						</tr>
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/genid"/></td>
							<td>
								<select class="t2" name="genid">
									<option value="query"><xsl:value-of select="$lng/genquery"/></option>
									<option value="sequence"><xsl:value-of select="$lng/gensequence"/></option>
								</select>
							</td>
						</tr>
					<xsl:if test="connections/transaction='1'">
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/transactionsupport"/></td>
							<td>
								<select class="t2" name="transaction">
									<option value="TRUE"><xsl:value-of select="$lng/enable"/></option>
									<option value="FALSE"><xsl:value-of select="$lng/disable"/></option>
								</select>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td></td>
							<td align="left">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/databasesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/databaseinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
