<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/installsecurity"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="install"/>
					<input type="hidden" name="function" value="newinstall_security"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="h t1" colspan="2"><xsl:value-of select="$lng/passwordsettings"/></td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/passwordhash"/></td>
							<td align="left" class="t2">
								<input name="passwordhash" value="urlencode" type="radio"/>
								<xsl:value-of select="$lng/none"/>
								<input name="passwordhash" value="md5" type="radio" checked="checked"/>
								<xsl:value-of select="$lng/md5"/>
								<input name="passwordhash" value="sha1" type="radio"/>
								<xsl:value-of select="$lng/sha1"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/passwordsaltpre"/></td>
							<td align="left" class="t2">
								<input name="passwordsaltpre" value="" type="text" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/passwordsaltpost"/></td>
							<td align="left" class="t2">
								<input name="passwordsaltpost" value="ts" type="text" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="right" class="t1"><xsl:value-of select="$lng/passwordscheme"/></td>
							<td align="left" class="t2">
								<select name="passwordscheme" class="t2">
									<option value="1">hash(password)</option>
									<option value="2" selected="TRUE">hash(pre_salt + password + post_salt)</option>
									<option value="3">hash(hash(pre_salt) + hash(password) + hash(post_salt))</option>
								</select>
							</td>
						</tr>
						<tr>
							<td></td>
							<td align="left">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/passwordheading"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/passwordinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
