<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<script>parent.left.location.href = "left.php"</script>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/successinstall"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'install'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="session"/>
					<input type="hidden" name="function" value="login"/>
					<input type="hidden" name="username" value="{user/username}"/>
					<input type="hidden" name="password" value="{user/password}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td align="left" class="e"><xsl:value-of select="$lng/removeinstall"/></td>
						</tr>
						<tr>
							<td align="left">
								<xsl:value-of select="$lng/username"/> : <xsl:value-of select="user/username"/>
							</td>
						</tr>
						<tr>
							<td align="left">
								<xsl:value-of select="$lng/password"/> : <xsl:value-of select="user/password"/>
							</td>
						</tr>
						<tr>
							<td>
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/login"/></xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/successheading"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/successinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
