<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create language
* @package TenderSystem
* @subpackage language
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

$params['isocodes'] = array(
	"aa","ab","af","am","ar","as","ay","az",
	"ba","be","bg","bh","bi","bn","bo","br",
	"ca","co","cs","cy",
	"da","de","dz",
	"el","en","eo","es","et","eu",
	"fa","fi","fj","fo","fr","fy",
	"ga","gd","gl","gn","gu",
	"ha","hi","hr","hu","hy",
	"ia","ie","ik","in","is","it","iw",
	"ja","ji","jw",
	"ka","kk","kl","km","kn","ko","ks","ku","ky",
	"la","ln","lo","lt","lv",
	"mg","mi","mk","ml","mn","mo","mr","ms","mt","my",
	"na","ne","nl","no",
	"oc","om","or",
	"pa","pl","ps","pt",
	"qu",
	"rm","rn","ro","ru","rw",
	"sa","sd","sg","sh","si","sk","sl","sm","sn","so","sq","sr","ss","st","su","sv","sw",
	"ta","te","tg","th","ti","tk","tl","tn","to","tr","ts","tt","tw",
	"uk","ur","uz",
	"vi","vo",
	"wo",
	"xh",
	"yo",
	"zh","zu"
);
if(!$cfg['languageeditor']['enable']) {
	// Not Enabled
	xml_generator("languageeditor","error","e44","",$cfg);
} elseif(!$_SESSION['ts_id']) {
	// No Session
	xml_generator("languageeditor","error","e17","",$cfg);
}
// field request errors and type 
$fields_request = array (
	'action'	=> array()	
);
get_request($fields_request,$action,$error,$cfg);
if ($action['action']) {
	// field request errors and type 
	$fields_request = array (
		'name'	=> array("e24",	REQUEST_ANY,	FORMAT_NONE,	"",	"lang")	
	);
	if(get_request($fields_request,$params,$error,$cfg)) {
		// create language folder in every module that has a language folder
		$file_path = "modules";
		// open the directory
		$dir = opendir($file_path);
		// if folder accessible
		if ($dir) {
			// loop through all the folders (modules)
			while(($file=readdir($dir)) !== FALSE) {
				// determine if hidden file not included
				if($file{0} != "." && $file != "CVS" && is_dir($file_path."/".$file)) {
					$full_path = $file_path."/".$file;
					// open the module directory
					$module_dir = opendir($full_path);
					if ($module_dir) {
						// loop through all the folders in the module
						while(($module_file=readdir($module_dir)) !== FALSE) {
							if(is_dir($full_path."/".$module_file) && $module_file=="language") {
								if(file_exists($full_path."/language/".$params['lang'])) {
									// folder already exists
									$error = "e3";
								} elseif(!mkdir($full_path."/language/".$params['lang'],0775)) {
									// failed to create folders
									$error = "e2";
								}
							}
						}
						// close the module directory
						closedir($module_dir);
					}
				}
			}
			// close the directory
			closedir($dir);
		} else {
			$error = "e4";
		}
		if($error) {
			// error 
			xml_generator("languageeditor","create",$error,$params,$cfg);
		} else {
			$params['module'] = "languageeditor";
			$params['function'] = "create";
			send_message($params,$cfg);
		}
	} else {
		// error 
		xml_generator("languageeditor","create",$error,$params,$cfg);
	}
} else {
	// display message
	xml_generator("languageeditor","create","",$params,$cfg);
}
?>